/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryMaker;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.impl.ResultProcessor;
import org.infinispan.query.dsl.embedded.impl.RowProcessor;
import org.infinispan.query.remote.impl.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.impl.ProtobufFieldBridgeProvider;
import org.infinispan.query.remote.impl.ProtobufIndexedFieldProvider;
import org.infinispan.query.remote.impl.filter.JPAProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.logging.Log;

final class RemoteQueryEngine
extends QueryEngine {
    private static final Log log = (Log)LogFactory.getLog(RemoteQueryEngine.class, Log.class);
    private final boolean isCompatMode;
    private final ProtobufFieldBridgeProvider protobufFieldBridgeProvider;

    public RemoteQueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed, boolean isCompatMode, SerializationContext serCtx) {
        super(cache, isIndexed, isCompatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class);
        this.isCompatMode = isCompatMode;
        this.protobufFieldBridgeProvider = new ProtobufFieldBridgeProvider(serCtx);
    }

    protected ResultProcessor makeResultProcessor(ResultProcessor in) {
        return result -> {
            if (result instanceof ProtobufValueWrapper) {
                result = ((ProtobufValueWrapper)result).getBinary();
            }
            return in != null ? in.process(result) : result;
        };
    }

    protected RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes) {
        if (this.isCompatMode) {
            return null;
        }
        int[] pos = new int[projectedTypes.length];
        int len = 0;
        for (int i = 0; i < projectedTypes.length; ++i) {
            if (projectedTypes[i] != Boolean.class) continue;
            pos[len++] = i;
        }
        if (len == 0) {
            return null;
        }
        int[] cols = len < pos.length ? Arrays.copyOf(pos, len) : pos;
        return row -> {
            for (int i : cols) {
                if (row[i] == null) continue;
                row[i] = "true".equals(row[i]);
            }
            return row;
        };
    }

    protected Query makeTypeQuery(Query query, String targetEntityName) {
        return this.isCompatMode ? query : new BooleanQuery.Builder().add(new BooleanClause((Query)new TermQuery(new Term("$type$", targetEntityName)), BooleanClause.Occur.MUST)).add(new BooleanClause(query, BooleanClause.Occur.MUST)).build();
    }

    protected JPAFilterAndConverter createFilter(String jpaQuery, Map<String, Object> namedParameters) {
        return this.isIndexed && !this.isCompatMode ? new JPAProtobufFilterAndConverter(jpaQuery, namedParameters) : new JPAFilterAndConverter(jpaQuery, namedParameters, this.matcher.getClass());
    }

    protected BooleShannonExpansion.IndexedFieldProvider getIndexedFieldProvider(FilterParsingResult<?> parsingResult) {
        return this.isCompatMode ? super.getIndexedFieldProvider(parsingResult) : new ProtobufIndexedFieldProvider((Descriptor)parsingResult.getTargetEntityMetadata());
    }

    protected Class<?> getTargetedClass(FilterParsingResult<?> parsingResult) {
        return this.isCompatMode ? (Class)parsingResult.getTargetEntityMetadata() : ProtobufValueWrapper.class;
    }

    protected LuceneQueryMaker createLuceneMaker() {
        return this.isCompatMode ? super.createLuceneMaker() : new LuceneQueryMaker(this.getSearchFactory(), null, (LuceneQueryMaker.FieldBridgeProvider)this.protobufFieldBridgeProvider);
    }
}

