/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.impl.ProtobufIndexedFieldProvider;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.ProtobufIndexedFieldProviderTest")
public class ProtobufIndexedFieldProviderTest
extends SingleCacheManagerTest {
    private static final String PROTO_DEFINITIONS = "/** @Indexed */ message User {\n\n   /** @IndexedField */ required string name = 1;\n\n   required string surname = 2;\n\n   /** @Indexed(true) */   message Address {\n      /** @IndexedField */ required string street = 10;\n      required string postCode = 20;\n   }\n\n   /** @IndexedField */ repeated Address indexedAddresses = 3; \n\n   /** @IndexedField(index=false, store=false) */ repeated Address unindexedAddresses = 4;\n}\n";

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testProvider() throws Exception {
        SerializationContext serCtx = ProtobufMetadataManagerImpl.getSerializationContext((EmbeddedCacheManager)this.cacheManager);
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"user_definition.proto", (String)PROTO_DEFINITIONS));
        ProtobufIndexedFieldProvider userIndexedFieldProvider = new ProtobufIndexedFieldProvider(serCtx.getMessageDescriptor("User"));
        ProtobufIndexedFieldProvider addressIndexedFieldProvider = new ProtobufIndexedFieldProvider(serCtx.getMessageDescriptor("User.Address"));
        AssertJUnit.assertTrue((boolean)userIndexedFieldProvider.isIndexed(new String[]{"name"}));
        AssertJUnit.assertFalse((boolean)userIndexedFieldProvider.isIndexed(new String[]{"surname"}));
        AssertJUnit.assertTrue((boolean)addressIndexedFieldProvider.isIndexed(new String[]{"street"}));
        AssertJUnit.assertFalse((boolean)addressIndexedFieldProvider.isIndexed(new String[]{"postCode"}));
        AssertJUnit.assertTrue((boolean)userIndexedFieldProvider.isIndexed(new String[]{"indexedAddresses", "street"}));
        AssertJUnit.assertFalse((boolean)userIndexedFieldProvider.isIndexed(new String[]{"indexedAddresses", "postCode"}));
        AssertJUnit.assertFalse((boolean)userIndexedFieldProvider.isIndexed(new String[]{"unindexedAddresses", "street"}));
        AssertJUnit.assertFalse((boolean)userIndexedFieldProvider.isIndexed(new String[]{"unindexedAddresses", "postCode"}));
    }
}

