/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.infinispan.protostream.MessageContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.impl.QueryFacadeImpl;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;

final class IndexingTagHandler
implements TagHandler {
    private static final LuceneOptions NOT_STORED_NOT_ANALYZED = new LuceneOptionsImpl(new DocumentFieldMetadata.Builder(null, Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO).indexNullAs(QueryFacadeImpl.NULL_TOKEN_CODEC).boost(Float.valueOf(1.0f)).build(), 1.0f, 1.0f);
    private static final LuceneOptions STORED_NOT_ANALYZED = new LuceneOptionsImpl(new DocumentFieldMetadata.Builder(null, Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO).indexNullAs(QueryFacadeImpl.NULL_TOKEN_CODEC).boost(Float.valueOf(1.0f)).build(), 1.0f, 1.0f);
    private final Document document;
    private MessageContext<MessageContext> messageContext;

    public IndexingTagHandler(Descriptor messageDescriptor, Document document) {
        this.document = document;
        this.messageContext = new MessageContext(null, null, messageDescriptor);
    }

    public void onStart() {
        NOT_STORED_NOT_ANALYZED.addFieldToDocument("$type$", this.messageContext.getMessageDescriptor().getFullName(), this.document);
    }

    public void onTag(int fieldNumber, String fieldName, Type type, JavaType javaType, Object tagValue) {
        IndexingMetadata indexingMetadata;
        this.messageContext.markField(fieldNumber);
        if (fieldName != null && ((indexingMetadata = (IndexingMetadata)this.messageContext.getMessageDescriptor().getProcessedAnnotation("Indexed")) == null || indexingMetadata.isFieldIndexed(fieldNumber))) {
            boolean isStored = indexingMetadata == null || indexingMetadata.isFieldStored(fieldNumber);
            this.addFieldToDocument(fieldName, type, tagValue, isStored);
        }
    }

    private void addFieldToDocument(String fieldName, Type type, Object value, boolean isStored) {
        LuceneOptions luceneOptions;
        LuceneOptions luceneOptions2 = luceneOptions = isStored ? STORED_NOT_ANALYZED : NOT_STORED_NOT_ANALYZED;
        if (value == null) {
            value = "_null_";
            type = Type.STRING;
            luceneOptions = NOT_STORED_NOT_ANALYZED;
        }
        String fn = this.getFullFieldName(fieldName);
        switch (type) {
            case DOUBLE: 
            case FLOAT: 
            case INT64: 
            case UINT64: 
            case INT32: 
            case FIXED64: 
            case FIXED32: 
            case UINT32: 
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: 
            case ENUM: {
                if (value.equals("_null_")) break;
                luceneOptions.addNumericFieldToDocument(fn, value, this.document);
                break;
            }
            case BOOL: {
                luceneOptions.addFieldToDocument(fn, value.toString(), this.document);
                break;
            }
            default: {
                luceneOptions.addFieldToDocument(fn, String.valueOf(value), this.document);
            }
        }
    }

    private String getFullFieldName(String fieldName) {
        String fieldPrefix = this.messageContext.getFullFieldName();
        return fieldPrefix != null ? fieldPrefix + "." + fieldName : fieldName;
    }

    public void onStartNested(int fieldNumber, String fieldName, Descriptor messageDescriptor) {
        this.messageContext.markField(fieldNumber);
        this.pushContext(fieldName, messageDescriptor);
    }

    public void onEndNested(int fieldNumber, String fieldName, Descriptor messageDescriptor) {
        this.popContext();
    }

    public void onEnd() {
        this.indexMissingFields();
    }

    private void pushContext(String fieldName, Descriptor messageDescriptor) {
        this.messageContext = new MessageContext(this.messageContext, fieldName, messageDescriptor);
    }

    private void popContext() {
        this.indexMissingFields();
        this.messageContext = this.messageContext.getParentContext();
    }

    private void indexMissingFields() {
        for (FieldDescriptor fd : this.messageContext.getMessageDescriptor().getFields()) {
            if (this.messageContext.isFieldMarked(fd.getNumber())) continue;
            Object defaultValue = fd.getJavaType() == JavaType.MESSAGE || fd.hasDefaultValue() ? fd.getDefaultValue() : null;
            IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageContext.getMessageDescriptor().getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && !indexingMetadata.isFieldIndexed(fd.getNumber())) continue;
            boolean isStored = indexingMetadata == null || indexingMetadata.isFieldStored(fd.getNumber());
            this.addFieldToDocument(fd.getName(), fd.getType(), defaultValue, isStored);
        }
    }
}

