/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.remote.client.ContinuousQueryResult;
import org.infinispan.query.remote.impl.ExternalizerIds;

public final class ContinuousQueryResultExternalizer
extends AbstractExternalizer<ContinuousQueryResult> {
    public void writeObject(ObjectOutput output, ContinuousQueryResult continuousQueryResult) throws IOException {
        output.writeInt(continuousQueryResult.getResultType().ordinal());
        output.writeInt(continuousQueryResult.getKey().length);
        output.write(continuousQueryResult.getKey());
        if (continuousQueryResult.getResultType() != ContinuousQueryResult.ResultType.LEAVING) {
            Object[] projection = continuousQueryResult.getProjection();
            if (projection == null) {
                output.writeInt(continuousQueryResult.getValue().length);
                output.writeObject(continuousQueryResult.getValue());
            } else {
                output.writeInt(-1);
                int projLen = projection.length;
                output.writeInt(projLen);
                for (Object prj : projection) {
                    output.writeObject(prj);
                }
            }
        }
    }

    public ContinuousQueryResult readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        ContinuousQueryResult.ResultType resultType = ContinuousQueryResult.ResultType.values()[input.readInt()];
        int keyLen = input.readInt();
        byte[] key = new byte[keyLen];
        input.readFully(key);
        byte[] value = null;
        Object[] projection = null;
        if (resultType != ContinuousQueryResult.ResultType.LEAVING) {
            int valueLen = input.readInt();
            if (valueLen == -1) {
                int projLen = input.readInt();
                projection = new Object[projLen];
                for (int i = 0; i < projLen; ++i) {
                    projection[i] = input.readObject();
                }
            } else {
                value = new byte[valueLen];
                input.readFully(value);
            }
        }
        return new ContinuousQueryResult(resultType, key, value, projection);
    }

    public Integer getId() {
        return ExternalizerIds.ICKLE_CONTINUOUS_QUERY_RESULT;
    }

    public Set<Class<? extends ContinuousQueryResult>> getTypeClasses() {
        return Collections.singleton(ContinuousQueryResult.class);
    }
}

