/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.CompatibilityQueryEngine;
import org.infinispan.query.remote.impl.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.RemoteQueryManager;

abstract class AbstractCompatRemoteQueryManager
implements RemoteQueryManager {
    private final CompatibilityReflectionMatcher compatibilityReflectionMatcher;
    private final BaseRemoteQueryEngine queryEngine;
    private final Encoder keyEncoder;
    private final Encoder valueEncoder;
    protected final SerializationContext ctx;
    protected final boolean isIndexed;

    AbstractCompatRemoteQueryManager(ComponentRegistry cr) {
        SearchIntegrator searchIntegrator = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        this.isIndexed = cfg.indexing().index().isEnabled();
        ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)cr.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        this.ctx = protobufMetadataManager.getSerializationContext();
        EntityNameResolver entityNameResolver = this.createEntityNamesResolver(cr);
        this.compatibilityReflectionMatcher = this.createMatcher(entityNameResolver, this.ctx, searchIntegrator);
        cache.getComponentRegistry().registerComponent((Object)this.compatibilityReflectionMatcher, CompatibilityReflectionMatcher.class);
        this.queryEngine = new CompatibilityQueryEngine(cache, this.isIndexed);
        this.keyEncoder = cache.getAdvancedCache().getKeyDataConversion().getEncoder();
        this.valueEncoder = cache.getAdvancedCache().getValueDataConversion().getEncoder();
    }

    abstract EntityNameResolver createEntityNamesResolver(ComponentRegistry var1);

    abstract CompatibilityReflectionMatcher createMatcher(EntityNameResolver var1, SerializationContext var2, SearchIntegrator var3);

    @Override
    public Matcher getMatcher() {
        return this.compatibilityReflectionMatcher;
    }

    @Override
    public BaseRemoteQueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public Object encodeFilterResult(Object filterResult) {
        return filterResult;
    }

    @Override
    public Encoder getKeyEncoder() {
        return this.keyEncoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.valueEncoder;
    }
}

