/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.dataconversion;

import java.io.IOException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamJsonTranscoder;
import org.infinispan.test.dataconversion.AbstractTranscoderTest;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.ProtostreamJsonTranscoderTest")
public class ProtostreamJsonTranscoderTest
extends AbstractTranscoderTest {
    private static final String PROTO_DEFINITIONS = "syntax = \"proto3\";\n\n    message Person {\n    optional string _type = 1;\n    optional string name = 2;\n\n    message Address {\n      optional string _type = 1;\n      optional string street = 2;\n      optional string city = 3;\n      optional string zip = 4;\n    }\n\n    optional Address address = 3;\n}";
    protected String dataSrc;

    @BeforeTest
    public void setUp() throws IOException {
        this.dataSrc = "{\"_type\":\"Person\", \"name\":\"joe\", \"address\":{\"_type\":\"Address\", \"street\":\"\", \"city\":\"London\", \"zip\":\"0\"}}";
        SerializationContext serCtx = ProtobufUtil.newSerializationContext((Configuration)Configuration.builder().build());
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"person_definition.proto", (String)PROTO_DEFINITIONS));
        this.transcoder = new ProtostreamJsonTranscoder(serCtx);
        this.supportedMediaTypes = this.transcoder.getSupportedMediaTypes();
    }

    @Test
    public void testTranscoderTranscode() throws Exception {
        Object transcoded = this.transcoder.transcode((Object)this.dataSrc.getBytes("UTF-8"), MediaType.APPLICATION_JSON, MediaType.APPLICATION_PROTOSTREAM);
        Assert.assertTrue((boolean)(transcoded instanceof byte[]), (String)"Must be byte[]");
        Object transcodedBack = this.transcoder.transcode(transcoded, MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_JSON);
        Assert.assertEquals((String)this.dataSrc.replace(" ", ""), (String)((String)transcodedBack).replace(" ", "").replace("\n", ""), (String)"Must be the same JSON string");
    }
}

