/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.dataconversion;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.impl.logging.Log;

public class ProtostreamObjectTranscoder
implements Transcoder {
    private static final Log log = (Log)LogFactory.getLog(ProtostreamObjectTranscoder.class, Log.class);
    private final Set<MediaType> supportedTypes;
    private final SerializationContext ctx;

    public ProtostreamObjectTranscoder(SerializationContext ctx) {
        this.ctx = ctx;
        this.supportedTypes = new HashSet<MediaType>();
        this.supportedTypes.add(MediaType.APPLICATION_OBJECT);
        this.supportedTypes.add(MediaType.APPLICATION_PROTOSTREAM);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                return ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.ctx, (byte[])((byte[])content));
            }
            if (destinationType.match(MediaType.APPLICATION_PROTOSTREAM)) {
                return ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx, (Object)content);
            }
        }
        catch (IOException e) {
            throw log.errorTranscoding(e);
        }
        throw log.unsupportedContent(content);
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return this.supportedTypes;
    }
}

