/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.ProtobufMetadataManagerInterceptorTest")
public class ProtobufMetadataManagerInterceptorTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager(this.makeCfg());
        this.addClusterEnabledCacheManager(this.makeCfg());
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder makeCfg() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).invocationBatching().enable().clustering().cacheMode(CacheMode.REPL_SYNC).clustering().sync().stateTransfer().fetchInMemoryState(true).transaction().lockingMode(LockingMode.PESSIMISTIC).locking().isolationLevel(IsolationLevel.READ_COMMITTED).useLockStriping(false).customInterceptors().addInterceptor().interceptor((AsyncInterceptor)new ProtobufMetadataManagerInterceptor()).after(PessimisticLockingInterceptor.class);
        return cfg;
    }

    @AfterMethod
    protected void clearContent() throws Throwable {
        this.cache(0).clear();
    }

    public void testValidatePut() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        AssertJUnit.assertTrue((boolean)cache0.isEmpty());
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        try {
            this.cache(0).put((Object)42, (Object)"import \"test.proto\";");
            AssertJUnit.fail();
        }
        catch (CacheException e) {
            AssertJUnit.assertEquals((String)"ISPN028007: The key must be a String : class java.lang.Integer", (String)e.getMessage());
        }
        try {
            this.cache(0).put((Object)"some.proto", (Object)42);
            AssertJUnit.fail();
        }
        catch (CacheException e) {
            AssertJUnit.assertEquals((String)"ISPN028008: The value must be a String : class java.lang.Integer", (String)e.getMessage());
        }
        try {
            cache0.put((Object)"some.xml", (Object)"import \"test.proto\";");
            AssertJUnit.fail();
        }
        catch (CacheException e) {
            AssertJUnit.assertEquals((String)"ISPN028009: The key must be a String ending with \".proto\" : some.xml", (String)e.getMessage());
        }
        cache0.put((Object)"test.proto", (Object)"package x");
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache0.get((Object)".errors")));
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache1.get((Object)".errors")));
        cache0.remove((Object)"test.proto");
        AssertJUnit.assertTrue((boolean)cache0.isEmpty());
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a.proto", "package a");
        map.put("b.proto", "package b;");
        cache0.putAll(map);
        AssertJUnit.assertEquals((String)"a.proto", (String)((String)cache0.get((Object)".errors")));
        AssertJUnit.assertEquals((String)"a.proto", (String)((String)cache1.get((Object)".errors")));
        AssertJUnit.assertEquals((int)4, (int)cache0.size());
        AssertJUnit.assertEquals((int)4, (int)cache1.size());
        this.assertNoTransactionsAndLocks();
    }

    public void testValidateReplace() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        AssertJUnit.assertTrue((boolean)cache0.isEmpty());
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        String value = "package X;";
        cache0.put((Object)"test.proto", (Object)value);
        AssertJUnit.assertEquals((int)1, (int)cache0.size());
        AssertJUnit.assertEquals((int)1, (int)cache1.size());
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)value, (String)((String)cache1.get((Object)"test.proto")));
        String newValue = "package XYX";
        cache0.replace((Object)"test.proto", (Object)newValue);
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache0.get((Object)".errors")));
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache1.get((Object)".errors")));
        AssertJUnit.assertEquals((int)3, (int)cache0.size());
        AssertJUnit.assertEquals((int)3, (int)cache1.size());
        AssertJUnit.assertEquals((String)newValue, (String)((String)cache0.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)newValue, (String)((String)cache1.get((Object)"test.proto")));
        this.assertNoTransactionsAndLocks();
    }

    public void testStatusAfterPut() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        AssertJUnit.assertTrue((boolean)cache0.isEmpty());
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        String value = "import \"missing.proto\";";
        cache0.put((Object)"test.proto", (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)value, (String)((String)cache1.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache0.get((Object)"test.proto.errors")));
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache0.get((Object)".errors")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache1.get((Object)"test.proto.errors")));
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache1.get((Object)".errors")));
        value = "package foobar;";
        cache0.put((Object)"test.proto", (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)value, (String)((String)cache1.get((Object)"test.proto")));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)"test.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"test.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)".errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)".errors"));
        this.assertNoTransactionsAndLocks();
    }

    public void testStatusAfterPutIfAbsent() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        AssertJUnit.assertTrue((boolean)cache0.isEmpty());
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        String value = "import \"missing.proto\";";
        cache0.putIfAbsent((Object)"test.proto", (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)value, (String)((String)cache1.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache0.get((Object)"test.proto.errors")));
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache0.get((Object)".errors")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache1.get((Object)"test.proto.errors")));
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache1.get((Object)".errors")));
        cache0.putIfAbsent((Object)"test.proto", (Object)"package foobar;");
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)value, (String)((String)cache1.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache0.get((Object)"test.proto.errors")));
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache0.get((Object)".errors")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache1.get((Object)"test.proto.errors")));
        AssertJUnit.assertEquals((String)"test.proto", (String)((String)cache1.get((Object)".errors")));
        value = "package foobar;";
        cache0.put((Object)"test.proto", (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)value, (String)((String)cache1.get((Object)"test.proto")));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)"test.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"test.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)".errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)".errors"));
        this.assertNoTransactionsAndLocks();
    }

    public void testStatusAfterPutAll() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        AssertJUnit.assertTrue((boolean)cache0.isEmpty());
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        String file1 = "import \"missing.proto\";";
        String file2 = "package b;";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a.proto", file1);
        map.put("b.proto", file2);
        cache0.putAll(map);
        AssertJUnit.assertEquals((String)file1, (String)((String)cache0.get((Object)"a.proto")));
        AssertJUnit.assertEquals((String)file2, (String)((String)cache0.get((Object)"b.proto")));
        AssertJUnit.assertEquals((String)file1, (String)((String)cache1.get((Object)"a.proto")));
        AssertJUnit.assertEquals((String)file2, (String)((String)cache1.get((Object)"b.proto")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache0.get((Object)"a.proto.errors")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache1.get((Object)"a.proto.errors")));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)"b.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"b.proto.errors"));
        AssertJUnit.assertTrue((boolean)cache0.containsKey((Object)".errors"));
        AssertJUnit.assertTrue((boolean)cache1.containsKey((Object)".errors"));
        AssertJUnit.assertEquals((String)"a.proto", (String)((String)cache0.get((Object)".errors")));
        AssertJUnit.assertEquals((String)"a.proto", (String)((String)cache1.get((Object)".errors")));
        file1 = "package a;";
        map.put("a.proto", file1);
        cache0.putAll(map);
        AssertJUnit.assertEquals((String)file1, (String)((String)cache0.get((Object)"a.proto")));
        AssertJUnit.assertEquals((String)file1, (String)((String)cache1.get((Object)"a.proto")));
        AssertJUnit.assertEquals((String)file2, (String)((String)cache0.get((Object)"b.proto")));
        AssertJUnit.assertEquals((String)file2, (String)((String)cache1.get((Object)"b.proto")));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)"a.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"a.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)"b.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"b.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)".errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)".errors"));
        this.assertNoTransactionsAndLocks();
    }

    public void testStatusAfterRemove() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        AssertJUnit.assertTrue((boolean)cache0.isEmpty());
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        String value = "import \"missing.proto\";";
        cache0.put((Object)"test.proto", (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)value, (String)((String)cache1.get((Object)"test.proto")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache0.get((Object)"test.proto.errors")));
        AssertJUnit.assertEquals((String)"Import 'missing.proto' not found", (String)((String)cache1.get((Object)"test.proto.errors")));
        cache0.remove((Object)"test.proto");
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)"test.proto"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"test.proto"));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)"test.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)"test.proto.errors"));
        AssertJUnit.assertFalse((boolean)cache0.containsKey((Object)".errors"));
        AssertJUnit.assertFalse((boolean)cache1.containsKey((Object)".errors"));
        this.assertNoTransactionsAndLocks();
    }

    private void assertNoTransactionsAndLocks() {
        this.assertNoTransactions();
        TestingUtil.assertNoLocks((Cache)this.cache(0));
        TestingUtil.assertNoLocks((Cache)this.cache(1));
    }
}

