/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.SecurityActions;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.core.QueryFacade;

public final class QueryFacadeImpl
implements QueryFacade {
    private static final Log log = (Log)LogFactory.getLog(QueryFacadeImpl.class, Log.class);
    public static final String TYPE_FIELD_NAME = "$type$";

    public byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        RemoteQueryManager remoteQueryManager;
        BaseRemoteQueryEngine queryEngine;
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
        if ((queryEngine = (remoteQueryManager = SecurityActions.getRemoteQueryManager(cache)).getQueryEngine()) == null) {
            throw log.queryingNotEnabled(cache.getName());
        }
        try {
            QueryRequest request = remoteQueryManager.decodeQueryRequest(query);
            long startOffset = request.getStartOffset() == null ? -1L : request.getStartOffset();
            int maxResults = request.getMaxResults() == null ? -1 : request.getMaxResults();
            IndexedQueryMode queryMode = IndexedQueryMode.FETCH;
            if (request.getIndexedQueryMode() != null) {
                queryMode = IndexedQueryMode.valueOf((String)request.getIndexedQueryMode());
            }
            Query q = queryEngine.makeQuery(request.getQueryString(), request.getNamedParametersMap(), startOffset, maxResults, queryMode);
            QueryResponse response = this.makeResponse(q);
            return remoteQueryManager.encodeQueryResponse(response);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debugf(e, "Error executing remote query : %s", e.getMessage());
            }
            throw e;
        }
    }

    private QueryResponse makeResponse(Query query) {
        List list = query.list();
        int numResults = list.size();
        String[] projection = query.getProjection();
        int projSize = projection != null ? projection.length : 0;
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? numResults : numResults * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int i = 0; i < projSize; ++i) {
                results.add(new WrappedMessage(row[i]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setTotalResults((long)query.getResultSize());
        response.setNumResults(numResults);
        response.setProjectionSize(projSize);
        response.setResults(results);
        return response;
    }
}

