/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.SearchMapping;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.query.remote.impl.ProtobufValueWrapperAnalyzerDiscriminator;
import org.infinispan.query.remote.impl.ProtobufValueWrapperIndexingInterceptor;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapperFieldBridge;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.query.spi.ProgrammaticSearchMappingProvider;

public final class ProgrammaticSearchMappingProviderImpl
implements ProgrammaticSearchMappingProvider {
    private static final Log log = (Log)LogFactory.getLog(ProgrammaticSearchMappingProviderImpl.class, Log.class);
    private static final String INDEX_NAME_SUFFIX = "_protobuf";

    public static String getIndexName(String cacheName) {
        return cacheName + INDEX_NAME_SUFFIX;
    }

    public void defineMappings(Cache cache, SearchMapping searchMapping) {
        if (log.isDebugEnabled()) {
            log.debugf("Enabling indexing for ProtobufValueWrapper in cache %s", cache.getName());
        }
        searchMapping.entity(ProtobufValueWrapper.class).indexed().indexName(ProgrammaticSearchMappingProviderImpl.getIndexName(cache.getName())).interceptor(ProtobufValueWrapperIndexingInterceptor.class).analyzerDiscriminator(ProtobufValueWrapperAnalyzerDiscriminator.class).classBridgeInstance((FieldBridge)new ProtobufValueWrapperFieldBridge(cache)).norms(Norms.NO).analyze(Analyze.NO).store(Store.NO);
    }
}

