/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.hibernate.search.analyzer.Discriminator;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.logging.Log;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.util.logging.LogFactory;

public final class ProtobufValueWrapperAnalyzerDiscriminator
implements Discriminator {
    private static final Log log = (Log)LogFactory.getLog(ProtobufValueWrapperAnalyzerDiscriminator.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();

    public String getAnalyzerDefinitionName(Object value, Object entity, String field) {
        if (field == null) {
            return null;
        }
        String[] fieldPath = field.split("\\.");
        if (entity instanceof ProtobufValueWrapper) {
            ProtobufValueWrapper wrapper = (ProtobufValueWrapper)entity;
            Descriptor messageDescriptor = wrapper.getMessageDescriptor();
            if (messageDescriptor != null) {
                return this.getAnalyzerForField(messageDescriptor, fieldPath);
            }
            throw new IllegalStateException("Message descriptor not initialized for " + wrapper);
        }
        return null;
    }

    private FieldDescriptor getFieldDescriptor(Descriptor messageDescriptor, String[] propertyPath) {
        FieldDescriptor fd = null;
        for (int i = 0; i < propertyPath.length; ++i) {
            String name = propertyPath[i];
            fd = messageDescriptor.findFieldByName(name);
            if (fd == null) {
                return null;
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && !indexingMetadata.isFieldIndexed(name)) {
                return null;
            }
            if (i >= propertyPath.length - 1) continue;
            messageDescriptor = fd.getMessageType();
        }
        return fd;
    }

    private String getAnalyzerForField(Descriptor messageDescriptor, String[] fieldPath) {
        FieldMapping fieldMapping;
        IndexingMetadata indexingMetadata;
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(messageDescriptor, fieldPath);
        if (fieldDescriptor != null && (indexingMetadata = (IndexingMetadata)fieldDescriptor.getContainingMessage().getProcessedAnnotation("Indexed")) != null && (fieldMapping = indexingMetadata.getFieldMapping(fieldDescriptor.getName())) != null && fieldMapping.analyze()) {
            String analyzerName = fieldMapping.analyzer();
            if (analyzerName == null || analyzerName.isEmpty()) {
                analyzerName = indexingMetadata.analyzer();
            }
            if (analyzerName != null && !analyzerName.isEmpty()) {
                if (trace) {
                    log.tracef("Using analyzer %s for field %s of type %s", (Object)analyzerName, (Object)fieldPath, (Object)messageDescriptor.getFullName());
                }
                return analyzerName;
            }
        }
        return null;
    }
}

