/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.dataconversion;

import java.io.IOException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamTextTranscoder;
import org.infinispan.test.dataconversion.AbstractTranscoderTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.ProtostreamTextTranscoderTest")
public class ProtostreamTextTranscoderTest
extends AbstractTranscoderTest {
    protected String dataSrc;

    @BeforeClass(alwaysRun=true)
    public void setUp() throws IOException {
        this.dataSrc = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
        this.transcoder = new ProtostreamTextTranscoder(ProtobufUtil.newSerializationContext());
        this.supportedMediaTypes = this.transcoder.getSupportedMediaTypes();
    }

    @Test
    public void testTranscoderTranscode() throws Exception {
        Object transcoded = this.transcoder.transcode((Object)this.dataSrc, MediaType.TEXT_PLAIN, MediaType.APPLICATION_PROTOSTREAM);
        Assert.assertTrue((boolean)(transcoded instanceof byte[]), (String)"Must be byte[]");
        Object transcodedBack = this.transcoder.transcode(transcoded, MediaType.APPLICATION_PROTOSTREAM, MediaType.TEXT_PLAIN);
        Assert.assertTrue((boolean)(transcodedBack instanceof String), (String)"Must be instance of String");
        Assert.assertEquals((Object)this.dataSrc, (Object)transcodedBack, (String)"Must be equal strings");
    }
}

