/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.consistenthash;

import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.Util;

public final class SegmentConsistentHash
implements ConsistentHash {
    private final Hash hash = new MurmurHash3();
    private SocketAddress[][] segmentOwners;
    private int segmentSize;

    @Override
    public void init(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, int hashSpace) {
    }

    public void init(SocketAddress[][] segmentOwners, int numSegments) {
        this.segmentOwners = segmentOwners;
        this.segmentSize = Util.getSegmentSize(numSegments);
    }

    @Override
    public SocketAddress getServer(byte[] key) {
        int segmentId = this.getSegment(key);
        return this.segmentOwners[segmentId][0];
    }

    private int getSegment(Object key) {
        return this.getNormalizedHash(key) / this.segmentSize;
    }

    @Override
    public int getNormalizedHash(Object object) {
        return Util.getNormalizedHash(object, this.hash);
    }
}

