/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.impl.WireFormat;

final class UnknownFieldSetImpl
implements UnknownFieldSet {
    private Map<Integer, Deque> fields;

    UnknownFieldSetImpl() {
    }

    private Deque getField(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag number");
        }
        ArrayDeque field = null;
        if (this.fields == null) {
            this.fields = new HashMap<Integer, Deque>();
        } else {
            field = this.fields.get(tag);
        }
        if (field == null) {
            field = new ArrayDeque();
            this.fields.put(tag, field);
        }
        return field;
    }

    @Override
    public boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    @Override
    public void readAllFields(CodedInputStream input) throws IOException {
        int tag;
        while ((tag = input.readTag()) != 0 && this.readSingleField(tag, input)) {
        }
    }

    @Override
    public boolean readSingleField(int tag, CodedInputStream input) throws IOException {
        int wireType = WireFormat.getTagWireType(tag);
        switch (wireType) {
            case 0: {
                this.getField(tag).addLast(input.readInt64());
                return true;
            }
            case 1: {
                this.getField(tag).addLast(input.readFixed64());
                return true;
            }
            case 2: {
                this.getField(tag).addLast(input.readBytes());
                return true;
            }
            case 3: {
                UnknownFieldSetImpl unknownFieldSet = new UnknownFieldSetImpl();
                unknownFieldSet.readAllFields(input);
                input.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                this.getField(tag).addLast(unknownFieldSet);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.getField(tag).addLast(input.readFixed32());
                return true;
            }
        }
        throw new InvalidProtocolBufferException("Protocol message tag had invalid wire type " + wireType);
    }

    @Override
    public void putVarintField(int tag, int value) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag");
        }
        if (WireFormat.getTagWireType(tag) != 0) {
            throw new IllegalArgumentException("The tag is not a VARINT");
        }
        this.getField(tag).addLast(value);
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.fields != null) {
            TreeMap<Integer, Deque> sorted = new TreeMap<Integer, Deque>(this.fields);
            for (Map.Entry entry : sorted.entrySet()) {
                this.writeField((Integer)entry.getKey(), (Deque)entry.getValue(), output);
            }
            output.flush();
        }
    }

    private void writeField(int tag, Deque values, CodedOutputStream output) throws IOException {
        int wireType = WireFormat.getTagWireType(tag);
        switch (wireType) {
            case 0: {
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    long value = (Long)i$.next();
                    output.writeRawVarint32(tag);
                    output.writeUInt64NoTag(value);
                }
                break;
            }
            case 5: {
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    int value = (Integer)i$.next();
                    output.writeRawVarint32(tag);
                    output.writeFixed32NoTag(value);
                }
                break;
            }
            case 1: {
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    long value = (Long)i$.next();
                    output.writeRawVarint32(tag);
                    output.writeFixed64NoTag(value);
                }
                break;
            }
            case 2: {
                for (ByteString value : values) {
                    output.writeRawVarint32(tag);
                    output.writeBytesNoTag(value);
                }
                break;
            }
            case 3: {
                for (UnknownFieldSetImpl value : values) {
                    output.writeRawVarint32(tag);
                    value.writeTo(output);
                    output.writeTag(WireFormat.getTagFieldNumber(tag), 4);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid wire type " + wireType);
            }
        }
    }

    public int getSerializedSize() {
        int result = 0;
        if (this.fields != null) {
            for (Map.Entry<Integer, Deque> entry : this.fields.entrySet()) {
                result += UnknownFieldSetImpl.computeSerializedFieldSize(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private static int computeSerializedFieldSize(int tag, Deque values) {
        int result = 0;
        int wireType = WireFormat.getTagWireType(tag);
        switch (wireType) {
            case 0: {
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    long value = (Long)i$.next();
                    result += CodedOutputStream.computeUInt64Size(tag, value);
                }
                break;
            }
            case 5: {
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    int value = (Integer)i$.next();
                    result += CodedOutputStream.computeFixed32Size(tag, value);
                }
                break;
            }
            case 1: {
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    long value = (Long)i$.next();
                    result += CodedOutputStream.computeFixed64Size(tag, value);
                }
                break;
            }
            case 2: {
                for (ByteString value : values) {
                    result += CodedOutputStream.computeBytesSize(tag, value);
                }
                break;
            }
            case 3: {
                for (UnknownFieldSetImpl value : values) {
                    result += CodedOutputStream.computeTagSize(tag) << 1 + value.getSerializedSize();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid wire type " + wireType);
            }
        }
        return result;
    }

    @Override
    public <A> A consumeTag(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag number");
        }
        int wireType = WireFormat.getTagWireType(tag);
        switch (wireType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid wire type " + wireType);
            }
        }
        if (this.fields == null) {
            return null;
        }
        Deque values = this.fields.get(tag);
        if (values == null) {
            return null;
        }
        Object value = values.pollFirst();
        if (values.isEmpty()) {
            this.fields.remove(tag);
        }
        return (A)value;
    }

    @Override
    public boolean hasTag(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag number");
        }
        return this.fields != null && this.fields.containsKey(tag);
    }
}

