/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.config.AnnotationConfig;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;

public final class Configuration {
    private final boolean logOutOfSequenceReads;
    private final boolean logOutOfSequenceWrites;
    private final Map<String, AnnotationConfig<Descriptor>> messageAnnotations;
    private final Map<String, AnnotationConfig<FieldDescriptor>> fieldAnnotations;
    private final Map<String, AnnotationConfig<EnumDescriptor>> enumAnnotations;

    private Configuration(boolean logOutOfSequenceReads, boolean logOutOfSequenceWrites, Map<String, AnnotationConfig<Descriptor>> messageAnnotations, Map<String, AnnotationConfig<FieldDescriptor>> fieldAnnotations, Map<String, AnnotationConfig<EnumDescriptor>> enumAnnotations) {
        this.logOutOfSequenceReads = logOutOfSequenceReads;
        this.logOutOfSequenceWrites = logOutOfSequenceWrites;
        this.messageAnnotations = Collections.unmodifiableMap(messageAnnotations);
        this.fieldAnnotations = Collections.unmodifiableMap(fieldAnnotations);
        this.enumAnnotations = Collections.unmodifiableMap(enumAnnotations);
    }

    public boolean logOutOfSequenceReads() {
        return this.logOutOfSequenceReads;
    }

    public boolean logOutOfSequenceWrites() {
        return this.logOutOfSequenceWrites;
    }

    public Map<String, AnnotationConfig<Descriptor>> messageAnnotations() {
        return this.messageAnnotations;
    }

    public Map<String, AnnotationConfig<FieldDescriptor>> fieldAnnotations() {
        return this.fieldAnnotations;
    }

    public Map<String, AnnotationConfig<EnumDescriptor>> enumAnnotations() {
        return this.enumAnnotations;
    }

    public String toString() {
        return "Configuration{logOutOfSequenceReads=" + this.logOutOfSequenceReads + ", logOutOfSequenceWrites=" + this.logOutOfSequenceWrites + ", messageAnnotations=" + this.messageAnnotations + ", fieldAnnotations=" + this.fieldAnnotations + ", enumAnnotations=" + this.enumAnnotations + '}';
    }

    public static final class Builder {
        private boolean logOutOfSequenceReads = true;
        private boolean logOutOfSequenceWrites = true;
        private final Map<String, AnnotationConfig.Builder<Descriptor>> messageAnnotationBuilders = new HashMap<String, AnnotationConfig.Builder<Descriptor>>();
        private final Map<String, AnnotationConfig.Builder<FieldDescriptor>> fieldAnnotationBuilders = new HashMap<String, AnnotationConfig.Builder<FieldDescriptor>>();
        private final Map<String, AnnotationConfig.Builder<EnumDescriptor>> enumAnnotationBuilders = new HashMap<String, AnnotationConfig.Builder<EnumDescriptor>>();

        public boolean isLogOutOfSequenceReads() {
            return this.logOutOfSequenceReads;
        }

        public Builder setLogOutOfSequenceReads(boolean logOutOfSequenceReads) {
            this.logOutOfSequenceReads = logOutOfSequenceReads;
            return this;
        }

        public boolean isLogOutOfSequenceWrites() {
            return this.logOutOfSequenceWrites;
        }

        public Builder setLogOutOfSequenceWrites(boolean logOutOfSequenceWrites) {
            this.logOutOfSequenceWrites = logOutOfSequenceWrites;
            return this;
        }

        public AnnotationConfig.Builder<Descriptor> messageAnnotation(String annotationName) {
            AnnotationConfig.Builder<Descriptor> builder = new AnnotationConfig.Builder<Descriptor>(this, annotationName);
            this.messageAnnotationBuilders.put(annotationName, builder);
            return builder;
        }

        public AnnotationConfig.Builder<EnumDescriptor> enumAnnotation(String annotationName) {
            AnnotationConfig.Builder<EnumDescriptor> builder = new AnnotationConfig.Builder<EnumDescriptor>(this, annotationName);
            this.enumAnnotationBuilders.put(annotationName, builder);
            return builder;
        }

        public AnnotationConfig.Builder<FieldDescriptor> fieldAnnotation(String annotationName) {
            AnnotationConfig.Builder<FieldDescriptor> builder = new AnnotationConfig.Builder<FieldDescriptor>(this, annotationName);
            this.fieldAnnotationBuilders.put(annotationName, builder);
            return builder;
        }

        public Configuration build() {
            HashMap<String, AnnotationConfig<Descriptor>> messageAnnotations = new HashMap<String, AnnotationConfig<Descriptor>>(this.messageAnnotationBuilders.size());
            for (AnnotationConfig.Builder<Descriptor> annotationBuilder : this.messageAnnotationBuilders.values()) {
                AnnotationConfig<Descriptor> annotationConfig = annotationBuilder.buildAnnotationConfig();
                messageAnnotations.put(annotationConfig.name(), annotationConfig);
            }
            HashMap<String, AnnotationConfig<FieldDescriptor>> fieldAnnotations = new HashMap<String, AnnotationConfig<FieldDescriptor>>(this.fieldAnnotationBuilders.size());
            for (AnnotationConfig.Builder<FieldDescriptor> annotationBuilder : this.fieldAnnotationBuilders.values()) {
                AnnotationConfig<FieldDescriptor> annotationConfig = annotationBuilder.buildAnnotationConfig();
                fieldAnnotations.put(annotationConfig.name(), annotationConfig);
            }
            HashMap<String, AnnotationConfig<EnumDescriptor>> enumAnnotations = new HashMap<String, AnnotationConfig<EnumDescriptor>>(this.enumAnnotationBuilders.size());
            for (AnnotationConfig.Builder<EnumDescriptor> annotationBuilder : this.enumAnnotationBuilders.values()) {
                AnnotationConfig<EnumDescriptor> annotationConfig = annotationBuilder.buildAnnotationConfig();
                enumAnnotations.put(annotationConfig.name(), annotationConfig);
            }
            return new Configuration(this.logOutOfSequenceReads, this.logOutOfSequenceWrites, messageAnnotations, fieldAnnotations, enumAnnotations);
        }
    }
}

