/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParser;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.MessageMarshallerDelegate;
import org.infinispan.protostream.impl.RawProtobufMarshallerDelegate;
import org.infinispan.protostream.impl.parser.SquareProtoParser;

public final class SerializationContextImpl
implements SerializationContext {
    private static final Log log = Log.LogFactory.getLog(SerializationContextImpl.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Configuration configuration;
    private final DescriptorParser parser;
    private final Map<String, FileDescriptor> fileDescriptors = new HashMap<String, FileDescriptor>();
    private final Map<String, GenericDescriptor> genericDescriptors = new HashMap<String, GenericDescriptor>();
    private final Map<String, BaseMarshallerDelegate<?>> marshallersByName = new ConcurrentHashMap();
    private final Map<Class<?>, BaseMarshallerDelegate<?>> marshallersByClass = new ConcurrentHashMap();

    public SerializationContextImpl(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        this.configuration = configuration;
        this.parser = new SquareProtoParser(configuration);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, FileDescriptor> getFileDescriptors() {
        this.readLock.lock();
        try {
            HashMap<String, FileDescriptor> hashMap = new HashMap<String, FileDescriptor>(this.fileDescriptors);
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProtoFiles(FileDescriptorSource source) throws IOException, DescriptorParserException {
        if (log.isDebugEnabled()) {
            log.debugf("Registering proto files : %s", (Object)source.getFileDescriptors().keySet());
        }
        Map<String, FileDescriptor> fileDescriptorMap = this.parser.parse(source);
        this.writeLock.lock();
        try {
            for (String fileName : fileDescriptorMap.keySet()) {
                FileDescriptor oldFileDescriptor = this.fileDescriptors.get(fileName);
                if (oldFileDescriptor == null) continue;
                this.unregisterFileDescriptorTypes(oldFileDescriptor);
            }
            this.fileDescriptors.putAll(fileDescriptorMap);
            for (FileDescriptor fileDescriptor : this.fileDescriptors.values()) {
                if (!fileDescriptor.resolveDependencies(source.getProgressCallback(), this.fileDescriptors, this.genericDescriptors)) continue;
                this.registerFileDescriptor(fileDescriptor);
            }
            for (FileDescriptor fileDescriptor : this.fileDescriptors.values()) {
                fileDescriptor.clearErrors();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProtoFile(String fileName) {
        log.debugf("Unregistering proto file : %s", (Object)fileName);
        this.writeLock.lock();
        try {
            FileDescriptor fileDescriptor = this.fileDescriptors.get(fileName);
            if (fileDescriptor != null) {
                this.fileDescriptors.remove(fileDescriptor.getName());
                this.unregisterFileDescriptorTypes(fileDescriptor);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @GuardedBy(value="writeLock")
    private void registerFileDescriptor(FileDescriptor fileDescriptor) {
        if (log.isDebugEnabled()) {
            log.debugf("Registering file descriptor : fileName=%s types=%s", (Object)fileDescriptor.getName(), (Object)fileDescriptor.getTypes().keySet());
        }
        this.fileDescriptors.put(fileDescriptor.getName(), fileDescriptor);
        this.genericDescriptors.putAll(fileDescriptor.getTypes());
    }

    @GuardedBy(value="writeLock")
    private void unregisterFileDescriptorTypes(FileDescriptor fileDescriptor) {
        this.genericDescriptors.keySet().removeAll(fileDescriptor.getTypes().keySet());
        for (FileDescriptor fd : fileDescriptor.getDependants().values()) {
            fd.markUnresolved();
            this.unregisterFileDescriptorTypes(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Descriptor getMessageDescriptor(String fullName) {
        this.readLock.lock();
        try {
            GenericDescriptor descriptor = this.genericDescriptors.get(fullName);
            if (descriptor == null) {
                throw new IllegalArgumentException("Message descriptor not found : " + fullName);
            }
            if (!(descriptor instanceof Descriptor)) {
                throw new IllegalArgumentException(fullName + " is not a message type");
            }
            Descriptor descriptor2 = (Descriptor)descriptor;
            return descriptor2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumDescriptor getEnumDescriptor(String fullName) {
        this.readLock.lock();
        try {
            GenericDescriptor descriptor = this.genericDescriptors.get(fullName);
            if (descriptor == null) {
                throw new IllegalArgumentException("Enum descriptor not found : " + fullName);
            }
            if (!(descriptor instanceof EnumDescriptor)) {
                throw new IllegalArgumentException(fullName + " is not an enum type");
            }
            EnumDescriptor enumDescriptor = (EnumDescriptor)descriptor;
            return enumDescriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public <T> void registerMarshaller(BaseMarshaller<T> marshaller) {
        BaseMarshallerDelegate marshallerDelegate;
        if (marshaller instanceof EnumMarshaller) {
            if (!marshaller.getJavaClass().isEnum()) {
                throw new IllegalArgumentException("Invalid enum marshaller (the produced class is not an Enum) : " + marshaller);
            }
            EnumDescriptor enumDescriptor = this.getEnumDescriptor(marshaller.getTypeName());
            marshallerDelegate = new EnumMarshallerDelegate((EnumMarshaller)marshaller, enumDescriptor);
        } else if (marshaller instanceof RawProtobufMarshaller) {
            marshallerDelegate = new RawProtobufMarshallerDelegate((RawProtobufMarshaller)marshaller, this);
        } else {
            Descriptor messageDescriptor = this.getMessageDescriptor(marshaller.getTypeName());
            marshallerDelegate = new MessageMarshallerDelegate((MessageMarshaller)marshaller, messageDescriptor);
        }
        this.marshallersByName.put(marshaller.getTypeName(), marshallerDelegate);
        this.marshallersByClass.put(marshaller.getJavaClass(), marshallerDelegate);
    }

    @Override
    public boolean canMarshall(Class clazz) {
        return this.marshallersByClass.containsKey(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canMarshall(String descriptorFullName) {
        this.readLock.lock();
        try {
            boolean bl = this.genericDescriptors.containsKey(descriptorFullName);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(String descriptorFullName) {
        return this.getMarshallerDelegate(descriptorFullName).getMarshaller();
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(Class<T> clazz) {
        return this.getMarshallerDelegate(clazz).getMarshaller();
    }

    <T> BaseMarshallerDelegate<T> getMarshallerDelegate(String descriptorFullName) {
        BaseMarshallerDelegate<?> marshallerDelegate = this.marshallersByName.get(descriptorFullName);
        if (marshallerDelegate == null) {
            throw new IllegalArgumentException("No marshaller registered for " + descriptorFullName);
        }
        return marshallerDelegate;
    }

    <T> BaseMarshallerDelegate<T> getMarshallerDelegate(Class<T> clazz) {
        BaseMarshallerDelegate<?> marshallerDelegate = this.marshallersByClass.get(clazz);
        if (marshallerDelegate == null) {
            throw new IllegalArgumentException("No marshaller registered for " + clazz);
        }
        return marshallerDelegate;
    }
}

