/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.WireFormat;

final class UnknownFieldSetImpl
implements UnknownFieldSet,
Externalizable {
    private Map<Integer, Deque<Object>> fields;

    private Deque<Object> getField(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag number");
        }
        Deque<Object> field = null;
        if (this.fields == null) {
            this.fields = new HashMap<Integer, Deque<Object>>();
        } else {
            field = this.fields.get(tag);
        }
        if (field == null) {
            field = new ArrayDeque<Object>();
            this.fields.put(tag, field);
        }
        return field;
    }

    @Override
    public boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    @Override
    public void readAllFields(RawProtoStreamReader input) throws IOException {
        int tag;
        while ((tag = input.readTag()) != 0 && this.readSingleField(tag, input)) {
        }
    }

    @Override
    public boolean readSingleField(int tag, RawProtoStreamReader input) throws IOException {
        int wireType = WireFormat.getTagWireType(tag);
        switch (wireType) {
            case 0: {
                this.getField(tag).addLast(input.readInt64());
                return true;
            }
            case 1: {
                this.getField(tag).addLast(input.readFixed64());
                return true;
            }
            case 2: {
                this.getField(tag).addLast(input.readByteArray());
                return true;
            }
            case 3: {
                UnknownFieldSetImpl unknownFieldSet = new UnknownFieldSetImpl();
                unknownFieldSet.readAllFields(input);
                input.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                this.getField(tag).addLast(unknownFieldSet);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.getField(tag).addLast(input.readFixed32());
                return true;
            }
        }
        throw new IOException("Protocol message tag had invalid wire type " + wireType);
    }

    @Override
    public void putVarintField(int tag, int value) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag");
        }
        if (WireFormat.getTagWireType(tag) != 0) {
            throw new IllegalArgumentException("The tag is not a VARINT");
        }
        this.getField(tag).addLast(value);
    }

    @Override
    public void writeTo(RawProtoStreamWriter output) throws IOException {
        if (this.fields != null) {
            TreeMap<Integer, Deque<Object>> sorted = new TreeMap<Integer, Deque<Object>>(this.fields);
            for (Map.Entry entry : sorted.entrySet()) {
                this.writeField((Integer)entry.getKey(), (Deque)entry.getValue(), output);
            }
            output.flush();
        }
    }

    private void writeField(int tag, Deque<?> values, RawProtoStreamWriter output) throws IOException {
        int wireType = WireFormat.getTagWireType(tag);
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        switch (wireType) {
            case 0: {
                Iterator<?> i$ = values.iterator();
                while (i$.hasNext()) {
                    long value = (Long)i$.next();
                    output.writeUInt64(fieldNumber, value);
                }
                break;
            }
            case 5: {
                Iterator<?> i$ = values.iterator();
                while (i$.hasNext()) {
                    int value = (Integer)i$.next();
                    output.writeFixed32(fieldNumber, value);
                }
                break;
            }
            case 1: {
                Iterator<?> i$ = values.iterator();
                while (i$.hasNext()) {
                    long value = (Long)i$.next();
                    output.writeFixed64(fieldNumber, value);
                }
                break;
            }
            case 2: {
                for (byte[] value : values) {
                    output.writeBytes(fieldNumber, value);
                }
                break;
            }
            case 3: {
                for (UnknownFieldSetImpl value : values) {
                    output.writeRawVarint32(tag);
                    value.writeTo(output);
                    output.writeTag(fieldNumber, 4);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid wire type " + wireType);
            }
        }
    }

    @Override
    public <A> A consumeTag(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag number");
        }
        int wireType = WireFormat.getTagWireType(tag);
        switch (wireType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid wire type " + wireType);
            }
        }
        if (this.fields == null) {
            return null;
        }
        Deque<Object> values = this.fields.get(tag);
        if (values == null) {
            return null;
        }
        Object value = values.pollFirst();
        if (values.isEmpty()) {
            this.fields.remove(tag);
        }
        return (A)value;
    }

    @Override
    public boolean hasTag(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag number");
        }
        return this.fields != null && this.fields.containsKey(tag);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RawProtoStreamWriter output = RawProtoStreamWriterImpl.newInstance(baos);
        this.writeTo(output);
        output.flush();
        byte[] bytes = baos.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int len = in.readInt();
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        this.readAllFields(RawProtoStreamReaderImpl.newInstance(bytes));
    }
}

