/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.infinispan.Cache;
import org.infinispan.cdi.ContextInputCache;
import org.infinispan.cdi.util.CDIHelper;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.spi.MapReduceTaskLifecycle;

public class DelegatingMapReduceTaskLifecycle
implements MapReduceTaskLifecycle {
    private final MapReduceTaskLifecycle delegate = CDIHelper.isCDIAvailable() ? new CDIMapReduceTaskLifecycle() : new NoCDIMapReduceTaskLifecycle();

    public <KIn, VIn, KOut, VOut> void onPreExecute(Mapper<KIn, VIn, KOut, VOut> mapper, Cache<KIn, VIn> inputCache) {
        this.delegate.onPreExecute(mapper, inputCache);
    }

    public <KIn, VIn, KOut, VOut> void onPostExecute(Mapper<KIn, VIn, KOut, VOut> mapper) {
        this.delegate.onPostExecute(mapper);
    }

    public <KOut, VOut> void onPreExecute(Reducer<KOut, VOut> reducer, Cache<?, ?> cache) {
        this.delegate.onPreExecute(reducer, cache);
    }

    public <KOut, VOut> void onPostExecute(Reducer<KOut, VOut> reducer) {
        this.delegate.onPostExecute(reducer);
    }

    static class CDIMapReduceTaskLifecycle
    implements MapReduceTaskLifecycle {
        CDIMapReduceTaskLifecycle() {
        }

        public <KIn, VIn, KOut, VOut> void onPreExecute(Mapper<KIn, VIn, KOut, VOut> mapper, Cache<KIn, VIn> inputCache) {
            BeanManager bm = CDIHelper.getBeanManager();
            if (bm == null) {
                return;
            }
            ContextInputCache.set(inputCache);
            Class<?> clazz = mapper.getClass();
            AnnotatedType type = bm.createAnnotatedType(clazz);
            InjectionTarget it = bm.createInjectionTarget(type);
            CreationalContext ctx = bm.createCreationalContext(null);
            it.inject(mapper, ctx);
            it.postConstruct(mapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <KIn, VIn, KOut, VOut> void onPostExecute(Mapper<KIn, VIn, KOut, VOut> mapper) {
            try {
                BeanManager bm = CDIHelper.getBeanManager();
                if (bm == null) {
                    return;
                }
                Class<?> clazz = mapper.getClass();
                AnnotatedType type = bm.createAnnotatedType(clazz);
                InjectionTarget it = bm.createInjectionTarget(type);
                it.preDestroy(mapper);
                it.dispose(mapper);
            }
            finally {
                ContextInputCache.clean();
            }
        }

        public <KOut, VOut> void onPreExecute(Reducer<KOut, VOut> reducer, Cache<?, ?> inputCache) {
            BeanManager bm = CDIHelper.getBeanManager();
            if (bm == null) {
                return;
            }
            Class<?> clazz = reducer.getClass();
            AnnotatedType type = bm.createAnnotatedType(clazz);
            InjectionTarget it = bm.createInjectionTarget(type);
            CreationalContext ctx = bm.createCreationalContext(null);
            it.inject(reducer, ctx);
            it.postConstruct(reducer);
        }

        public <KOut, VOut> void onPostExecute(Reducer<KOut, VOut> reducer) {
            BeanManager bm = CDIHelper.getBeanManager();
            if (bm == null) {
                return;
            }
            Class<?> clazz = reducer.getClass();
            AnnotatedType type = bm.createAnnotatedType(clazz);
            InjectionTarget it = bm.createInjectionTarget(type);
            it.preDestroy(reducer);
            it.dispose(reducer);
        }
    }

    static class NoCDIMapReduceTaskLifecycle
    implements MapReduceTaskLifecycle {
        NoCDIMapReduceTaskLifecycle() {
        }

        public <KIn, VIn, KOut, VOut> void onPreExecute(Mapper<KIn, VIn, KOut, VOut> mapper, Cache<KIn, VIn> inputCache) {
        }

        public <KIn, VIn, KOut, VOut> void onPostExecute(Mapper<KIn, VIn, KOut, VOut> mapper) {
        }

        public <KOut, VOut> void onPreExecute(Reducer<KOut, VOut> reducer, Cache<?, ?> inputCache) {
        }

        public <KOut, VOut> void onPostExecute(Reducer<KOut, VOut> reducer) {
        }
    }
}

