/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.BaseQuery;

public class ClientEvents {
    public static final String QUERY_DSL_FILTER_FACTORY_NAME = "query-dsl-filter-converter-factory";
    private static final ClientCacheFailoverEvent FAILOVER_EVENT_SINGLETON = new ClientCacheFailoverEvent(){

        @Override
        public ClientEvent.Type getType() {
            return ClientEvent.Type.CLIENT_CACHE_FAILOVER;
        }
    };

    private ClientEvents() {
    }

    public static ClientCacheFailoverEvent mkCachefailoverEvent() {
        return FAILOVER_EVENT_SINGLETON;
    }

    public static void addClientQueryListener(RemoteCache<?, ?> remoteCache, Object listener, Query query) {
        ClientListener l = listener.getClass().getAnnotation(ClientListener.class);
        if (!l.useRawData()) {
            throw new IllegalArgumentException("The client listener must use raw data");
        }
        if (!l.filterFactoryName().equals(QUERY_DSL_FILTER_FACTORY_NAME)) {
            throw new IllegalArgumentException("The client listener must use the 'query-dsl-filter-converter-factory' filter factory");
        }
        if (!l.converterFactoryName().equals(QUERY_DSL_FILTER_FACTORY_NAME)) {
            throw new IllegalArgumentException("The client listener must use the 'query-dsl-filter-converter-factory' converter factory");
        }
        Object[] factoryParams = new Object[]{((BaseQuery)query).getJPAQuery()};
        remoteCache.addClientListener(listener, factoryParams, factoryParams);
    }
}

