/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.WrappedMessage;

public final class FilterResult {
    private final Object instance;
    private final Object[] projection;
    private final Comparable[] sortProjection;

    public FilterResult(Object instance, Object[] projection, Comparable[] sortProjection) {
        if (instance == null && projection == null) {
            throw new IllegalArgumentException("instance and projection cannot be both null");
        }
        this.instance = instance;
        this.projection = projection;
        this.sortProjection = sortProjection;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    public Comparable[] getSortProjection() {
        return this.sortProjection;
    }

    public String toString() {
        return "FilterResult{instance=" + this.instance + ", projection=" + Arrays.toString(this.projection) + ", sortProjection=" + Arrays.toString(this.sortProjection) + '}';
    }

    public static final class Marshaller
    implements MessageMarshaller<FilterResult> {
        @Override
        public FilterResult readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            byte[] instance = reader.readBytes("instance");
            List projection = reader.readCollection("projection", new ArrayList(), WrappedMessage.class);
            List sortProjection = reader.readCollection("sortProjection", new ArrayList(), WrappedMessage.class);
            Object i = null;
            if (instance != null) {
                i = ProtobufUtil.fromWrappedByteArray(reader.getSerializationContext(), instance);
            }
            Object[] p = null;
            if (!projection.isEmpty()) {
                p = new Object[projection.size()];
                int j = 0;
                for (WrappedMessage m : projection) {
                    p[j++] = m.getValue();
                }
            }
            Comparable[] sp = null;
            if (!sortProjection.isEmpty()) {
                sp = new Comparable[sortProjection.size()];
                int j = 0;
                for (WrappedMessage m : sortProjection) {
                    sp[j++] = (Comparable)m.getValue();
                }
            }
            return new FilterResult(i, p, sp);
        }

        @Override
        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, FilterResult filterResult) throws IOException {
            int i;
            WrappedMessage[] p;
            if (filterResult.getProjection() == null) {
                writer.writeBytes("instance", (byte[])filterResult.getInstance());
            } else {
                p = new WrappedMessage[filterResult.getProjection().length];
                for (i = 0; i < p.length; ++i) {
                    p[i] = new WrappedMessage(filterResult.getProjection()[i]);
                }
                writer.writeArray("projection", p, WrappedMessage.class);
            }
            if (filterResult.getSortProjection() != null) {
                p = new WrappedMessage[filterResult.getSortProjection().length];
                for (i = 0; i < p.length; ++i) {
                    p[i] = new WrappedMessage(filterResult.getSortProjection()[i]);
                }
                writer.writeArray("sortProjection", p, WrappedMessage.class);
            }
        }

        @Override
        public Class<? extends FilterResult> getJavaClass() {
            return FilterResult.class;
        }

        @Override
        public String getTypeName() {
            return "org.infinispan.query.remote.client.FilterResult";
        }
    }
}

