/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.protocol.mgmt;

import infinispan.org.jboss.as.protocol.StreamUtils;
import infinispan.org.jboss.as.protocol.mgmt.ActiveOperation;
import infinispan.org.jboss.as.protocol.mgmt.FlushableDataOutput;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestContext;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import infinispan.org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import java.io.DataInput;
import java.io.IOException;

public class ManagementPongRequestHandler
implements ManagementRequestHandlerFactory,
ManagementRequestHandler<Void, Void> {
    private volatile long connectionId = System.currentTimeMillis();

    @Override
    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationId = header.getOperationId();
        switch (operationId) {
            case 5: {
                handlers.registerActiveOperation(header.getBatchId(), null);
                return this;
            }
        }
        return handlers.resolveNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context) throws IOException {
        ManagementResponseHeader response = ManagementResponseHeader.create(context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage(response);
        try {
            output.write(6);
            output.writeLong(this.connectionId);
            output.writeByte(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose(output);
        }
        resultHandler.done(null);
    }

    public void resetConnectionId() {
        this.connectionId = System.currentTimeMillis();
    }

    public long getConnectionId() {
        return this.connectionId;
    }
}

