/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules;

import infinispan.org.jboss.modules.IterableLocalLoader;
import infinispan.org.jboss.modules.Resource;
import infinispan.org.jboss.modules.filter.ClassFilter;
import infinispan.org.jboss.modules.filter.PathFilter;
import infinispan.org.jboss.modules.filter.PathFilters;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class FilteredIterableLocalLoader
implements IterableLocalLoader {
    private final ClassFilter classFilter;
    private final IterableLocalLoader originalLoader;
    private final PathFilter resourcePathFilter;

    FilteredIterableLocalLoader(ClassFilter classFilter, PathFilter resourcePathFilter, IterableLocalLoader originalLoader) {
        this.classFilter = classFilter;
        this.originalLoader = originalLoader;
        this.resourcePathFilter = resourcePathFilter;
    }

    @Override
    public Class<?> loadClassLocal(String name, boolean resolve) {
        return this.classFilter.accept(name) ? this.originalLoader.loadClassLocal(name, resolve) : null;
    }

    @Override
    public Package loadPackageLocal(String name) {
        return this.originalLoader.loadPackageLocal(name);
    }

    @Override
    public List<Resource> loadResourceLocal(String name) {
        return this.resourcePathFilter.accept(name) ? this.originalLoader.loadResourceLocal(name) : Collections.emptyList();
    }

    @Override
    public Iterator<Resource> iterateResources(String startPath, boolean recursive) {
        return PathFilters.filtered(this.resourcePathFilter, this.originalLoader.iterateResources(startPath, recursive));
    }
}

