/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.threads;

import infinispan.org.jboss.threads.DirectExecutor;
import infinispan.org.jboss.threads.JBossThread;

class ThreadFormattedNameExecutor
implements DirectExecutor {
    private final String nameFormat;
    private final DirectExecutor delegate;

    ThreadFormattedNameExecutor(String nameFormat, DirectExecutor delegate) {
        this.nameFormat = nameFormat;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        JBossThread thr = JBossThread.currentThread();
        String oldName = thr.getName();
        thr.setName(thr.getThreadNameInfo().format(thr, this.nameFormat));
        try {
            this.delegate.execute(command);
        }
        finally {
            thr.setName(oldName);
        }
    }

    public String toString() {
        return String.format("%s format=\"%s\" -> %s", super.toString(), this.nameFormat, this.delegate);
    }
}

