/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio;

import infinispan.org.xnio.ChannelListener;
import infinispan.org.xnio.ChannelPipe;
import infinispan.org.xnio.IoFuture;
import infinispan.org.xnio.LocalSocketAddress;
import infinispan.org.xnio.MessageConnection;
import infinispan.org.xnio.OptionMap;
import infinispan.org.xnio.StreamConnection;
import infinispan.org.xnio.Xnio;
import infinispan.org.xnio.XnioExecutor;
import infinispan.org.xnio.XnioIoFactory;
import infinispan.org.xnio.XnioWorker;
import infinispan.org.xnio._private.Messages;
import infinispan.org.xnio.channels.AssembledStreamChannel;
import infinispan.org.xnio.channels.BoundChannel;
import infinispan.org.xnio.channels.StreamChannel;
import infinispan.org.xnio.channels.StreamSinkChannel;
import infinispan.org.xnio.channels.StreamSourceChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class XnioIoThread
extends Thread
implements XnioExecutor,
XnioIoFactory {
    private final XnioWorker worker;
    private final int number;

    protected XnioIoThread(XnioWorker worker, int number) {
        this.number = number;
        this.worker = worker;
    }

    protected XnioIoThread(XnioWorker worker, int number, String name) {
        super(name);
        this.number = number;
        this.worker = worker;
    }

    protected XnioIoThread(XnioWorker worker, int number, ThreadGroup group, String name) {
        super(group, name);
        this.number = number;
        this.worker = worker;
    }

    protected XnioIoThread(XnioWorker worker, int number, ThreadGroup group, String name, long stackSize) {
        super(group, null, name, stackSize);
        this.number = number;
        this.worker = worker;
    }

    public static XnioIoThread currentThread() {
        Thread thread = Thread.currentThread();
        if (thread instanceof XnioIoThread) {
            return (XnioIoThread)thread;
        }
        return null;
    }

    public static XnioIoThread requireCurrentThread() throws IllegalStateException {
        XnioIoThread thread = XnioIoThread.currentThread();
        if (thread == null) {
            throw Messages.msg.xnioThreadRequired();
        }
        return thread;
    }

    public int getNumber() {
        return this.number;
    }

    public XnioWorker getWorker() {
        return this.worker;
    }

    @Override
    public IoFuture<StreamConnection> acceptStreamConnection(SocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw Messages.msg.nullParameter("destination");
        }
        if (destination instanceof InetSocketAddress) {
            return this.acceptTcpStreamConnection((InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptLocalStreamConnection((LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    protected IoFuture<StreamConnection> acceptLocalStreamConnection(LocalSocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("acceptLocalStreamConnection");
    }

    protected IoFuture<StreamConnection> acceptTcpStreamConnection(InetSocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("acceptTcpStreamConnection");
    }

    @Override
    public IoFuture<MessageConnection> openMessageConnection(SocketAddress destination, ChannelListener<? super MessageConnection> openListener, OptionMap optionMap) {
        if (destination == null) {
            throw Messages.msg.nullParameter("destination");
        }
        if (destination instanceof LocalSocketAddress) {
            return this.openLocalMessageConnection(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    @Override
    public IoFuture<MessageConnection> acceptMessageConnection(SocketAddress destination, ChannelListener<? super MessageConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw Messages.msg.nullParameter("destination");
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptLocalMessageConnection((LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    protected IoFuture<MessageConnection> acceptLocalMessageConnection(LocalSocketAddress destination, ChannelListener<? super MessageConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("acceptLocalMessageConnection");
    }

    @Override
    public IoFuture<StreamConnection> openStreamConnection(SocketAddress destination, ChannelListener<? super StreamConnection> openListener, OptionMap optionMap) {
        if (destination == null) {
            throw Messages.msg.nullParameter("destination");
        }
        if (destination instanceof InetSocketAddress) {
            return this.openTcpStreamConnection(Xnio.ANY_INET_ADDRESS, (InetSocketAddress)destination, openListener, null, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.openLocalStreamConnection(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, null, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    @Override
    public IoFuture<StreamConnection> openStreamConnection(SocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw Messages.msg.nullParameter("destination");
        }
        if (destination instanceof InetSocketAddress) {
            return this.openTcpStreamConnection(Xnio.ANY_INET_ADDRESS, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.openLocalStreamConnection(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    @Override
    public IoFuture<StreamConnection> openStreamConnection(SocketAddress bindAddress, SocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (bindAddress == null) {
            throw Messages.msg.nullParameter("bindAddress");
        }
        if (destination == null) {
            throw Messages.msg.nullParameter("destination");
        }
        if (bindAddress.getClass() != destination.getClass()) {
            throw Messages.msg.mismatchSockType(bindAddress.getClass(), destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            return this.openTcpStreamConnection((InetSocketAddress)bindAddress, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.openLocalStreamConnection((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    protected IoFuture<StreamConnection> openTcpStreamConnection(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("openTcpStreamConnection");
    }

    protected IoFuture<StreamConnection> openLocalStreamConnection(LocalSocketAddress bindAddress, LocalSocketAddress destinationAddress, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("openLocalStreamConnection");
    }

    protected IoFuture<MessageConnection> openLocalMessageConnection(LocalSocketAddress bindAddress, LocalSocketAddress destinationAddress, ChannelListener<? super MessageConnection> openListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("openLocalMessageConnection");
    }

    @Override
    public ChannelPipe<StreamChannel, StreamChannel> createFullDuplexPipe() throws IOException {
        ChannelPipe<StreamConnection, StreamConnection> connection = this.createFullDuplexPipeConnection();
        AssembledStreamChannel left = new AssembledStreamChannel(connection.getLeftSide(), connection.getLeftSide().getSourceChannel(), connection.getLeftSide().getSinkChannel());
        AssembledStreamChannel right = new AssembledStreamChannel(connection.getRightSide(), connection.getRightSide().getSourceChannel(), connection.getRightSide().getSinkChannel());
        return new ChannelPipe<StreamChannel, StreamChannel>(left, right);
    }

    @Override
    public ChannelPipe<StreamConnection, StreamConnection> createFullDuplexPipeConnection() throws IOException {
        return this.createFullDuplexPipeConnection(this);
    }

    @Override
    public ChannelPipe<StreamSourceChannel, StreamSinkChannel> createHalfDuplexPipe() throws IOException {
        return this.createHalfDuplexPipe(this);
    }

    @Override
    public ChannelPipe<StreamConnection, StreamConnection> createFullDuplexPipeConnection(XnioIoFactory peer) throws IOException {
        throw Messages.msg.unsupported("createFullDuplexPipeConnection");
    }

    @Override
    public ChannelPipe<StreamSourceChannel, StreamSinkChannel> createHalfDuplexPipe(XnioIoFactory peer) throws IOException {
        throw Messages.msg.unsupported("createHalfDuplexPipe");
    }
}

