/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.conduits;

import infinispan.org.xnio.ChannelListener;
import infinispan.org.xnio.Option;
import infinispan.org.xnio.XnioExecutor;
import infinispan.org.xnio.XnioIoThread;
import infinispan.org.xnio.XnioWorker;
import infinispan.org.xnio.channels.CloseListenerSettable;
import infinispan.org.xnio.channels.Configurable;
import infinispan.org.xnio.channels.WritableMessageChannel;
import infinispan.org.xnio.channels.WriteListenerSettable;
import infinispan.org.xnio.conduits.MessageSinkConduit;
import infinispan.org.xnio.conduits.WriteReadyHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public final class ConduitWritableMessageChannel
implements WritableMessageChannel,
WriteListenerSettable<ConduitWritableMessageChannel>,
CloseListenerSettable<ConduitWritableMessageChannel>,
Cloneable {
    private final Configurable configurable;
    private MessageSinkConduit conduit;
    private ChannelListener<? super ConduitWritableMessageChannel> writeListener;
    private ChannelListener<? super ConduitWritableMessageChannel> closeListener;

    public ConduitWritableMessageChannel(Configurable configurable, MessageSinkConduit conduit) {
        this.configurable = configurable;
        this.conduit = conduit;
        conduit.setWriteReadyHandler(new WriteReadyHandler.ChannelListenerHandler<ConduitWritableMessageChannel>(this));
    }

    public MessageSinkConduit getConduit() {
        return this.conduit;
    }

    public void setConduit(MessageSinkConduit conduit) {
        this.conduit = conduit;
    }

    @Override
    public ChannelListener<? super ConduitWritableMessageChannel> getWriteListener() {
        return this.writeListener;
    }

    @Override
    public void setWriteListener(ChannelListener<? super ConduitWritableMessageChannel> writeListener) {
        this.writeListener = writeListener;
    }

    @Override
    public ChannelListener<? super ConduitWritableMessageChannel> getCloseListener() {
        return this.closeListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super ConduitWritableMessageChannel> closeListener) {
        this.closeListener = closeListener;
    }

    public ChannelListener.Setter<ConduitWritableMessageChannel> getWriteSetter() {
        return new WriteListenerSettable.Setter<ConduitWritableMessageChannel>(this);
    }

    public ChannelListener.Setter<ConduitWritableMessageChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<ConduitWritableMessageChannel>(this);
    }

    @Override
    public void suspendWrites() {
        this.conduit.suspendWrites();
    }

    @Override
    public void resumeWrites() {
        this.conduit.resumeWrites();
    }

    @Override
    public void wakeupWrites() {
        this.conduit.wakeupWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.conduit.isWriteResumed();
    }

    @Override
    public void awaitWritable() throws IOException {
        this.conduit.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.conduit.awaitWritable(time, timeUnit);
    }

    @Override
    public boolean send(ByteBuffer dst) throws IOException {
        return this.conduit.send(dst);
    }

    @Override
    public boolean send(ByteBuffer[] srcs) throws IOException {
        return this.conduit.send(srcs, 0, srcs.length);
    }

    @Override
    public boolean send(ByteBuffer[] dsts, int offs, int len) throws IOException {
        return this.conduit.send(dsts, offs, len);
    }

    @Override
    public boolean sendFinal(ByteBuffer buffer) throws IOException {
        return this.conduit.sendFinal(buffer);
    }

    @Override
    public boolean sendFinal(ByteBuffer[] buffers) throws IOException {
        return this.conduit.sendFinal(buffers, 0, buffers.length);
    }

    @Override
    public boolean sendFinal(ByteBuffer[] buffers, int offs, int len) throws IOException {
        return this.conduit.sendFinal(buffers, offs, len);
    }

    @Override
    public boolean flush() throws IOException {
        return this.conduit.flush();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.configurable.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.configurable.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.configurable.setOption(option, value);
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.conduit.terminateWrites();
    }

    @Override
    public boolean isOpen() {
        return !this.conduit.isWriteShutdown();
    }

    @Override
    public void close() throws IOException {
        this.conduit.truncateWrites();
    }

    @Override
    @Deprecated
    public XnioExecutor getWriteThread() {
        return this.conduit.getWriteThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.conduit.getWriteThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.conduit.getWorker();
    }

    public ConduitWritableMessageChannel clone() {
        try {
            return (ConduitWritableMessageChannel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

