/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.conduits;

import infinispan.org.xnio.ChannelListener;
import infinispan.org.xnio.ChannelListeners;
import infinispan.org.xnio.IoUtils;
import infinispan.org.xnio.channels.CloseListenerSettable;
import infinispan.org.xnio.channels.ReadListenerSettable;
import infinispan.org.xnio.channels.SuspendableReadChannel;
import infinispan.org.xnio.conduits.TerminateHandler;

public interface ReadReadyHandler
extends TerminateHandler {
    public void readReady();

    public static class ReadyTask
    implements Runnable {
        private final ReadReadyHandler handler;

        public ReadyTask(ReadReadyHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.readReady();
        }
    }

    public static class ChannelListenerHandler<C extends SuspendableReadChannel & ReadListenerSettable<C>>
    implements ReadReadyHandler {
        private final C channel;

        public ChannelListenerHandler(C channel) {
            this.channel = channel;
        }

        @Override
        public void forceTermination() {
            IoUtils.safeClose(this.channel);
        }

        @Override
        public void readReady() {
            ChannelListener readListener = ((ReadListenerSettable)this.channel).getReadListener();
            if (readListener == null) {
                this.channel.suspendReads();
            } else {
                ChannelListeners.invokeChannelListener(this.channel, readListener);
            }
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(this.channel, ((CloseListenerSettable)this.channel).getCloseListener());
        }
    }
}

