/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.nio;

import infinispan.org.xnio.Option;
import infinispan.org.xnio.Options;
import infinispan.org.xnio.nio.AbstractNioStreamConnection;
import infinispan.org.xnio.nio.NioSocketConduit;
import infinispan.org.xnio.nio.NioTcpServerHandle;
import infinispan.org.xnio.nio.WorkerThread;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Set;

final class NioSocketStreamConnection
extends AbstractNioStreamConnection {
    private final NioTcpServerHandle serverConduit;
    private final NioSocketConduit conduit;
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add((Option<?>)Options.CLOSE_ABORT).add((Option<?>)Options.IP_TRAFFIC_CLASS).add((Option<?>)Options.KEEP_ALIVE).add((Option<?>)Options.READ_TIMEOUT).add((Option<?>)Options.RECEIVE_BUFFER).add((Option<?>)Options.SEND_BUFFER).add((Option<?>)Options.TCP_NODELAY).add((Option<?>)Options.TCP_OOB_INLINE).add((Option<?>)Options.WRITE_TIMEOUT).create();

    NioSocketStreamConnection(WorkerThread workerThread, SelectionKey key, NioTcpServerHandle serverConduit) {
        super(workerThread);
        this.conduit = new NioSocketConduit(workerThread, key, this);
        key.attach(this.conduit);
        this.serverConduit = serverConduit;
        this.setSinkConduit(this.conduit);
        this.setSourceConduit(this.conduit);
    }

    @Override
    public SocketAddress getPeerAddress() {
        Socket socket = this.conduit.getSocketChannel().socket();
        return new InetSocketAddress(socket.getInetAddress(), socket.getPort());
    }

    @Override
    public SocketAddress getLocalAddress() {
        Socket socket = this.conduit.getSocketChannel().socket();
        return new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.CLOSE_ABORT) {
            return option.cast(this.conduit.getSocketChannel().socket().getSoLinger() == 0);
        }
        if (option == Options.IP_TRAFFIC_CLASS) {
            return option.cast(this.conduit.getSocketChannel().socket().getTrafficClass());
        }
        if (option == Options.KEEP_ALIVE) {
            return option.cast(this.conduit.getSocketChannel().socket().getKeepAlive());
        }
        if (option == Options.READ_TIMEOUT) {
            return option.cast(this.conduit.getReadTimeout());
        }
        if (option == Options.RECEIVE_BUFFER) {
            return option.cast(this.conduit.getSocketChannel().socket().getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            return option.cast(this.conduit.getSocketChannel().socket().getSendBufferSize());
        }
        if (option == Options.TCP_NODELAY) {
            return option.cast(this.conduit.getSocketChannel().socket().getTcpNoDelay());
        }
        if (option == Options.TCP_OOB_INLINE) {
            return option.cast(this.conduit.getSocketChannel().socket().getOOBInline());
        }
        if (option == Options.WRITE_TIMEOUT) {
            return option.cast(this.conduit.getWriteTimeout());
        }
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        T result;
        if (option == Options.CLOSE_ABORT) {
            result = option.cast(this.conduit.getSocketChannel().socket().getSoLinger() == 0);
            this.conduit.getSocketChannel().socket().setSoLinger(Options.CLOSE_ABORT.cast(value, Boolean.FALSE), 0);
        } else if (option == Options.IP_TRAFFIC_CLASS) {
            result = option.cast(this.conduit.getSocketChannel().socket().getTrafficClass());
            this.conduit.getSocketChannel().socket().setTrafficClass(Options.IP_TRAFFIC_CLASS.cast(value));
        } else if (option == Options.KEEP_ALIVE) {
            result = option.cast(this.conduit.getSocketChannel().socket().getKeepAlive());
            this.conduit.getSocketChannel().socket().setKeepAlive(Options.KEEP_ALIVE.cast(value, Boolean.FALSE));
        } else if (option == Options.READ_TIMEOUT) {
            result = option.cast(this.conduit.getAndSetReadTimeout(value == null ? 0 : Options.READ_TIMEOUT.cast(value)));
        } else if (option == Options.RECEIVE_BUFFER) {
            result = option.cast(this.conduit.getSocketChannel().socket().getReceiveBufferSize());
            this.conduit.getSocketChannel().socket().setReceiveBufferSize(Options.RECEIVE_BUFFER.cast(value));
        } else if (option == Options.SEND_BUFFER) {
            result = option.cast(this.conduit.getSocketChannel().socket().getSendBufferSize());
            this.conduit.getSocketChannel().socket().setSendBufferSize(Options.SEND_BUFFER.cast(value));
        } else if (option == Options.TCP_NODELAY) {
            result = option.cast(this.conduit.getSocketChannel().socket().getTcpNoDelay());
            this.conduit.getSocketChannel().socket().setTcpNoDelay(Options.TCP_NODELAY.cast(value, Boolean.FALSE));
        } else if (option == Options.TCP_OOB_INLINE) {
            result = option.cast(this.conduit.getSocketChannel().socket().getOOBInline());
            this.conduit.getSocketChannel().socket().setOOBInline(Options.TCP_OOB_INLINE.cast(value, Boolean.FALSE));
        } else if (option == Options.WRITE_TIMEOUT) {
            result = option.cast(this.conduit.getAndSetWriteTimeout(value == null ? 0 : Options.WRITE_TIMEOUT.cast(value)));
        } else {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() throws IOException {
        try {
            this.conduit.getWorkerThread().cancelKey(this.conduit.getSelectionKey());
            this.conduit.getSocketChannel().close();
        }
        catch (ClosedChannelException ignored) {
        }
        finally {
            NioTcpServerHandle conduit = this.serverConduit;
            if (conduit != null) {
                conduit.channelClosed();
            }
        }
    }

    @Override
    protected void notifyWriteClosed() {
        this.conduit.writeTerminated();
    }

    @Override
    protected void notifyReadClosed() {
        this.conduit.readTerminated();
    }

    SocketChannel getChannel() {
        return this.conduit.getSocketChannel();
    }

    NioSocketConduit getConduit() {
        return this.conduit;
    }
}

