/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.streams;

import infinispan.org.xnio._private.Messages;
import java.io.IOException;
import java.io.InputStream;

public final class LimitedInputStream
extends InputStream {
    private final InputStream delegate;
    private long remaining;
    private long mark = -1L;

    public LimitedInputStream(InputStream delegate, long size) {
        this.delegate = delegate;
        this.remaining = size;
    }

    @Override
    public int read() throws IOException {
        long remaining = this.remaining;
        if (remaining > 0L) {
            int b = this.delegate.read();
            if (b > 0) {
                this.remaining = remaining - 1L;
            }
            return b;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long remaining = this.remaining;
        if (remaining == 0L) {
            return -1;
        }
        int cnt = this.delegate.read(b, off, (int)Math.min((long)len, remaining));
        if (cnt == -1) {
            return -1;
        }
        this.remaining = remaining - (long)cnt;
        return cnt;
    }

    @Override
    public long skip(long n) throws IOException {
        long remaining = this.remaining;
        if (remaining == 0L || n <= 0L) {
            return 0L;
        }
        long cnt = this.delegate.skip(Math.min(n, remaining));
        if (cnt > 0L) {
            this.remaining = remaining - cnt;
        }
        return cnt;
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.delegate.available(), (int)Math.min(Integer.MAX_VALUE, this.remaining));
    }

    @Override
    public void close() throws IOException {
        this.remaining = 0L;
        this.delegate.close();
    }

    @Override
    public void mark(int limit) {
        if (this.markSupported()) {
            this.delegate.mark(limit);
            this.mark = this.remaining;
        }
    }

    @Override
    public void reset() throws IOException {
        long mark = this.mark;
        if (mark == -1L) {
            throw Messages.msg.markNotSet();
        }
        this.delegate.reset();
        this.remaining = mark;
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

