/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import infinispan.org.jboss.logging.Logger;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.FilterConditionBeginContext;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.AttributeCondition;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.IncompleteCondition;
import org.infinispan.query.dsl.impl.NotCondition;
import org.infinispan.query.dsl.impl.logging.Log;

public abstract class BaseQueryFactory<T extends Query>
implements QueryFactory<T> {
    private static final Log log = Logger.getMessageLogger(Log.class, BaseQueryFactory.class.getName());

    @Override
    public FilterConditionEndContext having(String attributePath) {
        return this.having(Expression.property(attributePath));
    }

    @Override
    public FilterConditionEndContext having(Expression expression) {
        return new AttributeCondition(this, expression);
    }

    @Override
    public FilterConditionBeginContext not() {
        return new IncompleteCondition(this).not();
    }

    @Override
    public FilterConditionContext not(FilterConditionContext fcc) {
        if (fcc == null) {
            throw log.argumentCannotBeNull();
        }
        BaseCondition baseCondition = ((BaseCondition)fcc).getRoot();
        if (baseCondition.queryFactory != this) {
            throw new IllegalArgumentException("The given condition was created by a different factory");
        }
        if (baseCondition.queryBuilder != null) {
            throw new IllegalArgumentException("The given condition is already in use by another builder");
        }
        NotCondition notCondition = new NotCondition(this, baseCondition);
        baseCondition.setParent(notCondition);
        return notCondition;
    }
}

