/*
 * Decompiled with CFR 0.152.
 */
package infinispan.com.squareup.protoparser;

import infinispan.com.squareup.protoparser.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Option {
    private final String name;
    private final Object value;

    public static Map<String, Object> optionsAsMap(List<Option> options) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Option option : options) {
            String name = option.getName();
            Object value = option.getValue();
            if (value instanceof String || value instanceof List) {
                map.put(name, value);
                continue;
            }
            if (value instanceof Option) {
                Map<String, Object> newMap = Option.optionsAsMap(Arrays.asList((Option)value));
                Object oldValue = map.get(name);
                if (oldValue instanceof Map) {
                    LinkedHashMap<String, Object> oldMap = (LinkedHashMap<String, Object>)oldValue;
                    oldMap = new LinkedHashMap<String, Object>(oldMap);
                    oldMap.putAll(newMap);
                    map.put(name, oldMap);
                    continue;
                }
                map.put(name, newMap);
                continue;
            }
            if (value instanceof Map) {
                Object oldValue = map.get(name);
                if (oldValue instanceof Map) {
                    ((Map)oldValue).putAll((Map)value);
                    continue;
                }
                map.put(name, value);
                continue;
            }
            throw new AssertionError((Object)"Option value must be String, Option, List, or Map<String, ?>");
        }
        return Collections.unmodifiableMap(map);
    }

    public static Option findByName(List<Option> options, String name) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        Option found = null;
        for (Option option : options) {
            if (!option.getName().equals(name)) continue;
            if (found != null) {
                throw new IllegalStateException("Multiple options match name: " + name);
            }
            found = option;
        }
        return found;
    }

    public Option(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Option)) {
            return false;
        }
        Option that = (Option)other;
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    public int hashCode() {
        return this.name.hashCode() + 37 * this.value.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.value instanceof String) {
            String stringValue = (String)this.value;
            builder.append(this.name).append(" = \"").append(Option.escape(stringValue)).append('\"');
        } else if (this.value instanceof Option) {
            Option optionValue = (Option)this.value;
            builder.append('(').append(this.name).append(").").append(optionValue.toString());
        } else if (this.value instanceof List) {
            builder.append(this.name).append(" = [\n");
            List optionList = (List)this.value;
            int count = optionList.size();
            for (int i = 0; i < count; ++i) {
                String endl = i < count - 1 ? "," : "";
                Utils.appendIndented(builder, ((Option)optionList.get(i)).toString() + endl);
            }
            builder.append(']');
        } else {
            throw new IllegalStateException("Unknown value type " + this.value.getClass().getCanonicalName());
        }
        return builder.toString();
    }

    public String toDeclaration() {
        return "option " + this.toString() + ";\n";
    }

    static String escape(String string) {
        return string.replace("\\", "\\\\").replace("\t", "\\t").replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
    }
}

