/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.remoting3.remote;

import infinispan.org.jboss.logging.Logger;
import infinispan.org.jboss.remoting3.RemotingOptions;
import infinispan.org.jboss.remoting3.remote.RemoteConnectionProvider;
import infinispan.org.jboss.remoting3.remote.RemoteLogger;
import infinispan.org.jboss.remoting3.spi.ConnectionHandlerFactory;
import infinispan.org.xnio.Buffers;
import infinispan.org.xnio.ChannelListener;
import infinispan.org.xnio.IoUtils;
import infinispan.org.xnio.OptionMap;
import infinispan.org.xnio.Pool;
import infinispan.org.xnio.Pooled;
import infinispan.org.xnio.Result;
import infinispan.org.xnio.XnioExecutor;
import infinispan.org.xnio.channels.ConnectedMessageChannel;
import infinispan.org.xnio.channels.ConnectedStreamChannel;
import infinispan.org.xnio.channels.SslChannel;
import infinispan.org.xnio.sasl.SaslWrapper;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

final class RemoteConnection {
    static final Pooled<ByteBuffer> STARTTLS_SENTINEL = Buffers.emptyPooledByteBuffer();
    private static final String FQCN = RemoteConnection.class.getName();
    private final Pool<ByteBuffer> messageBufferPool;
    private final ConnectedMessageChannel channel;
    private final ConnectedStreamChannel underlyingChannel;
    private final OptionMap optionMap;
    private final RemoteWriteListener writeListener = new RemoteWriteListener();
    private final Executor executor;
    private final int heartbeatInterval;
    private volatile Result<ConnectionHandlerFactory> result;
    private volatile SaslWrapper saslWrapper;
    private final RemoteConnectionProvider remoteConnectionProvider;
    private final Runnable heartbeatCommand = new Runnable(){

        @Override
        public void run() {
            RemoteConnection.this.sendAlive();
        }
    };

    RemoteConnection(Pool<ByteBuffer> messageBufferPool, ConnectedStreamChannel underlyingChannel, ConnectedMessageChannel channel, OptionMap optionMap, RemoteConnectionProvider remoteConnectionProvider) {
        this.messageBufferPool = messageBufferPool;
        this.underlyingChannel = underlyingChannel;
        this.channel = channel;
        this.optionMap = optionMap;
        this.heartbeatInterval = optionMap.get(RemotingOptions.HEARTBEAT_INTERVAL, Integer.MAX_VALUE);
        this.executor = remoteConnectionProvider.getExecutor();
        this.remoteConnectionProvider = remoteConnectionProvider;
    }

    Pooled<ByteBuffer> allocate() {
        return this.messageBufferPool.allocate();
    }

    void setReadListener(ChannelListener<? super ConnectedMessageChannel> listener, boolean resume) {
        RemoteLogger.log.logf(RemoteConnection.class.getName(), Logger.Level.TRACE, (Throwable)null, "Setting read listener to %s", (Object)listener);
        this.channel.getReadSetter().set(listener);
        if (listener != null && resume) {
            this.channel.resumeReads();
        }
    }

    RemoteConnectionProvider getRemoteConnectionProvider() {
        return this.remoteConnectionProvider;
    }

    Result<ConnectionHandlerFactory> getResult() {
        return this.result;
    }

    void setResult(Result<ConnectionHandlerFactory> result) {
        this.result = result;
    }

    void handleException(IOException e) {
        this.handleException(e, true);
    }

    void handleException(IOException e, boolean log) {
        XnioExecutor.Key key;
        RemoteLogger.conn.logf(RemoteConnection.class.getName(), Logger.Level.TRACE, (Throwable)e, "Connection error detail", new Object[0]);
        if (log) {
            RemoteLogger.conn.connectionError(e);
        }
        if ((key = this.writeListener.heartKey) != null) {
            key.remove();
        }
        IoUtils.safeClose((Closeable)this.channel);
        Result<ConnectionHandlerFactory> result = this.result;
        if (result != null) {
            result.setException(e);
            this.result = null;
        }
    }

    void send(Pooled<ByteBuffer> pooled) {
        this.writeListener.send(pooled, false);
    }

    void send(Pooled<ByteBuffer> pooled, boolean close) {
        this.writeListener.send(pooled, close);
    }

    void shutdownWrites() {
        this.writeListener.shutdownWrites();
    }

    OptionMap getOptionMap() {
        return this.optionMap;
    }

    ConnectedMessageChannel getChannel() {
        return this.channel;
    }

    ChannelListener<ConnectedMessageChannel> getWriteListener() {
        return this.writeListener;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public SslChannel getSslChannel() {
        return this.underlyingChannel instanceof SslChannel ? (SslChannel)((Object)this.underlyingChannel) : null;
    }

    SaslWrapper getSaslWrapper() {
        return this.saslWrapper;
    }

    void setSaslWrapper(SaslWrapper saslWrapper) {
        this.saslWrapper = saslWrapper;
    }

    void handlePreAuthCloseRequest() {
        try {
            this.terminateHeartbeat();
            this.channel.close();
        }
        catch (IOException e) {
            RemoteLogger.conn.debug("Error closing remoting channel", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAlive() {
        Pooled<ByteBuffer> pooled = this.allocate();
        boolean ok = false;
        try {
            ByteBuffer buffer = pooled.getResource();
            buffer.put((byte)-16);
            buffer.limit(80);
            Buffers.addRandom(buffer);
            buffer.flip();
            this.send(pooled);
            ok = true;
            this.channel.wakeupReads();
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAliveResponse() {
        Pooled<ByteBuffer> pooled = this.allocate();
        boolean ok = false;
        try {
            ByteBuffer buffer = pooled.getResource();
            buffer.put((byte)-15);
            buffer.limit(80);
            Buffers.addRandom(buffer);
            buffer.flip();
            this.send(pooled);
            ok = true;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    void terminateHeartbeat() {
        XnioExecutor.Key key = this.writeListener.heartKey;
        if (key != null) {
            key.remove();
        }
    }

    Object getLock() {
        return this.writeListener.queue;
    }

    public String toString() {
        return String.format("Remoting connection %08x to %s", this.hashCode(), this.channel.getPeerAddress());
    }

    final class RemoteWriteListener
    implements ChannelListener<ConnectedMessageChannel> {
        private final Queue<Pooled<ByteBuffer>> queue = new ArrayDeque<Pooled<ByteBuffer>>();
        private XnioExecutor.Key heartKey;
        private boolean closed;

        RemoteWriteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(ConnectedMessageChannel channel) {
            Queue<Pooled<ByteBuffer>> queue = this.queue;
            synchronized (queue) {
                block16: {
                    assert (channel == RemoteConnection.this.getChannel());
                    Queue<Pooled<ByteBuffer>> queue2 = this.queue;
                    try {
                        Pooled<ByteBuffer> pooled;
                        while ((pooled = queue2.peek()) != null) {
                            ByteBuffer buffer = pooled.getResource();
                            if (buffer.hasRemaining()) {
                                if (channel.send(buffer)) {
                                    RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Sent message %s (via queue)", (Object)buffer);
                                    queue2.poll().free();
                                    continue;
                                }
                                return;
                            }
                            if (pooled == STARTTLS_SENTINEL) {
                                if (channel.flush()) {
                                    SslChannel sslChannel = RemoteConnection.this.getSslChannel();
                                    assert (sslChannel != null);
                                    sslChannel.startHandshake();
                                } else {
                                    return;
                                }
                            }
                            queue2.poll().free();
                        }
                        if (!channel.flush()) break block16;
                        RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Flushed channel", new Object[0]);
                        if (this.closed) {
                            RemoteConnection.this.terminateHeartbeat();
                            channel.shutdownWrites();
                            if (channel.flush()) {
                                RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Shut down writes on channel", new Object[0]);
                                return;
                            }
                            return;
                        }
                        this.heartKey = channel.getWriteThread().executeAfter(RemoteConnection.this.heartbeatCommand, RemoteConnection.this.heartbeatInterval, TimeUnit.MILLISECONDS);
                        channel.suspendWrites();
                    }
                    catch (IOException e) {
                        Pooled<ByteBuffer> pooled;
                        RemoteConnection.this.handleException(e, false);
                        channel.wakeupReads();
                        while ((pooled = queue2.poll()) != null) {
                            pooled.free();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownWrites() {
            Queue<Pooled<ByteBuffer>> queue = this.queue;
            synchronized (queue) {
                this.closed = true;
                RemoteConnection.this.terminateHeartbeat();
                ConnectedMessageChannel channel = RemoteConnection.this.getChannel();
                try {
                    if (!this.queue.isEmpty()) {
                        channel.resumeWrites();
                        return;
                    }
                    channel.shutdownWrites();
                    if (!channel.flush()) {
                        channel.resumeWrites();
                        return;
                    }
                    RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Shut down writes on channel", new Object[0]);
                }
                catch (IOException e) {
                    Pooled<ByteBuffer> unqueued;
                    RemoteConnection.this.handleException(e, false);
                    channel.wakeupReads();
                    while ((unqueued = this.queue.poll()) != null) {
                        unqueued.free();
                    }
                }
            }
        }

        public void send(final Pooled<ByteBuffer> pooled, final boolean close) {
            RemoteConnection.this.channel.getIoThread().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Queue queue = RemoteWriteListener.this.queue;
                    synchronized (queue) {
                        XnioExecutor.Key heartKey = RemoteWriteListener.this.heartKey;
                        if (heartKey != null) {
                            heartKey.remove();
                        }
                        if (RemoteWriteListener.this.closed) {
                            pooled.free();
                            return;
                        }
                        if (close) {
                            RemoteWriteListener.this.closed = true;
                        }
                        ConnectedMessageChannel channel = RemoteConnection.this.getChannel();
                        boolean free = true;
                        try {
                            ByteBuffer buffer;
                            SaslWrapper wrapper = RemoteConnection.this.saslWrapper;
                            if (wrapper != null) {
                                buffer = (ByteBuffer)pooled.getResource();
                                ByteBuffer source = buffer.duplicate();
                                buffer.clear();
                                wrapper.wrap(buffer, source);
                                buffer.flip();
                            }
                            buffer = (ByteBuffer)pooled.getResource();
                            RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Can't directly send message %s, enqueued", (Object)buffer);
                            boolean empty = RemoteWriteListener.this.queue.isEmpty();
                            RemoteWriteListener.this.queue.add(pooled);
                            free = false;
                            if (empty) {
                                channel.resumeWrites();
                            }
                        }
                        catch (IOException e) {
                            Pooled unqueued;
                            RemoteConnection.this.handleException(e, false);
                            channel.wakeupReads();
                            while ((unqueued = (Pooled)RemoteWriteListener.this.queue.poll()) != null) {
                                unqueued.free();
                            }
                        }
                        finally {
                            if (free) {
                                pooled.free();
                            }
                        }
                    }
                }
            });
        }
    }
}

