/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio;

import infinispan.org.xnio.Buffers;
import infinispan.org.xnio._private.Messages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class ByteString
implements Comparable<ByteString>,
Serializable,
CharSequence {
    private static final long serialVersionUID = -5998895518404718196L;
    private final byte[] bytes;
    private final int offs;
    private final int len;
    private transient int hashCode;
    private transient int hashCodeIgnoreCase;
    private static final ByteString ZERO = new ByteString(new byte[]{48});

    private ByteString(byte[] bytes, int offs, int len) {
        this.bytes = bytes;
        this.offs = offs;
        this.len = len;
        if (offs < 0) {
            throw Messages.msg.parameterOutOfRange("offs");
        }
        if (len < 0) {
            throw Messages.msg.parameterOutOfRange("len");
        }
        if (offs + len > bytes.length) {
            throw Messages.msg.parameterOutOfRange("offs");
        }
    }

    private static int calcHashCode(byte[] bytes, int offs, int len) {
        int hc = 31;
        int end = offs + len;
        for (int i = offs; i < end; ++i) {
            hc = (hc << 5) - hc + (bytes[i] & 0xFF);
        }
        return hc == 0 ? Integer.MAX_VALUE : hc;
    }

    private static int calcHashCodeIgnoreCase(byte[] bytes, int offs, int len) {
        int hc = 31;
        int end = offs + len;
        for (int i = offs; i < end; ++i) {
            hc = (hc << 5) - hc + (ByteString.upperCase(bytes[i]) & 0xFF);
        }
        return hc == 0 ? Integer.MAX_VALUE : hc;
    }

    private ByteString(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public static ByteString of(byte ... bytes) {
        return new ByteString((byte[])bytes.clone());
    }

    public static ByteString copyOf(byte[] b, int offs, int len) {
        return new ByteString(Arrays.copyOfRange(b, offs, offs + len));
    }

    public static ByteString getBytes(String str, String charset) throws UnsupportedEncodingException {
        return new ByteString(str.getBytes(charset));
    }

    public static ByteString getBytes(String str, Charset charset) {
        return new ByteString(str.getBytes(charset));
    }

    public static ByteString getBytes(String str) {
        int length = str.length();
        return new ByteString(ByteString.getStringBytes(false, new byte[length], 0, str, 0, length), 0, length);
    }

    public static ByteString getBytes(ByteBuffer buffer) {
        return new ByteString(Buffers.take(buffer));
    }

    public static ByteString getBytes(ByteBuffer buffer, int length) {
        return new ByteString(Buffers.take(buffer, length));
    }

    public byte[] getBytes() {
        return Arrays.copyOfRange(this.bytes, this.offs, this.len);
    }

    public void getBytes(byte[] dest) {
        this.copyTo(dest);
    }

    public void getBytes(byte[] dest, int offs) {
        this.copyTo(dest, offs);
    }

    public void getBytes(byte[] dest, int offs, int len) {
        this.copyTo(dest, offs, len);
    }

    public void copyTo(int srcOffs, byte[] dst, int offs, int len) {
        System.arraycopy(this.bytes, srcOffs + this.offs, dst, offs, Math.min(this.len, len));
    }

    public void copyTo(byte[] dst, int offs, int len) {
        this.copyTo(0, dst, offs, len);
    }

    public void copyTo(byte[] dst, int offs) {
        this.copyTo(dst, offs, dst.length - offs);
    }

    public void copyTo(byte[] dst) {
        this.copyTo(dst, 0, dst.length);
    }

    public void appendTo(ByteBuffer dest) {
        dest.put(this.bytes, this.offs, this.len);
    }

    public int tryAppendTo(int offs, ByteBuffer buffer) {
        byte[] b = this.bytes;
        int len = Math.min(buffer.remaining(), b.length - offs);
        buffer.put(b, offs + this.offs, len);
        return len;
    }

    public void writeTo(OutputStream output) throws IOException {
        output.write(this.bytes, this.offs, this.len);
    }

    @Override
    public int compareTo(ByteString other) {
        if (other == this) {
            return 0;
        }
        int length = this.len;
        int otherLength = other.len;
        int len1 = Math.min(length, otherLength);
        byte[] bytes = this.bytes;
        byte[] otherBytes = other.bytes;
        int offs = this.offs;
        int otherOffs = other.offs;
        for (int i = 0; i < len1; ++i) {
            int res = Integer.signum(bytes[i + offs] - otherBytes[i + otherOffs]);
            if (res == 0) continue;
            return res;
        }
        return Integer.signum(length - otherLength);
    }

    public int compareToIgnoreCase(ByteString other) {
        if (other == this) {
            return 0;
        }
        if (other == this) {
            return 0;
        }
        int length = this.len;
        int otherLength = other.len;
        int len1 = Math.min(length, otherLength);
        byte[] bytes = this.bytes;
        byte[] otherBytes = other.bytes;
        int offs = this.offs;
        int otherOffs = other.offs;
        for (int i = 0; i < len1; ++i) {
            int res = Integer.signum(ByteString.upperCase(bytes[i + offs]) - ByteString.upperCase(otherBytes[i + otherOffs]));
            if (res == 0) continue;
            return res;
        }
        return Integer.signum(length - otherLength);
    }

    private static int upperCase(byte b) {
        return b >= 97 && b <= 122 ? b & 0xDF : b;
    }

    public String toString(String charset) throws UnsupportedEncodingException {
        if ("ISO-8859-1".equalsIgnoreCase(charset) || "Latin-1".equalsIgnoreCase(charset) || "ISO-Latin-1".equals(charset)) {
            return this.toString();
        }
        return new String(this.bytes, this.offs, this.len, charset);
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public String toString() {
        return new String(this.bytes, 0, this.offs, this.len);
    }

    public String toUtf8String() {
        return new String(this.bytes, this.offs, this.len, StandardCharsets.UTF_8);
    }

    public byte byteAt(int idx) {
        if (idx < 0 || idx > this.len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.bytes[idx + this.offs];
    }

    public ByteString substring(int offs) {
        return this.substring(offs, this.len - offs);
    }

    public ByteString substring(int offs, int len) {
        if (this.len - offs < len) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteString(this.bytes, this.offs + offs, len);
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            this.hashCode = hashCode = ByteString.calcHashCode(this.bytes, this.offs, this.len);
        }
        return hashCode;
    }

    public int hashCodeIgnoreCase() {
        int hashCode = this.hashCodeIgnoreCase;
        if (hashCode == 0) {
            this.hashCodeIgnoreCase = hashCode = ByteString.calcHashCodeIgnoreCase(this.bytes, this.offs, this.len);
        }
        return hashCode;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    private static boolean equals(byte[] a, int aoff, byte[] b, int boff, int len) {
        for (int i = 0; i < len; ++i) {
            if (a[i + aoff] == b[i + boff]) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsIgnoreCase(byte[] a, int aoff, byte[] b, int boff, int len) {
        for (int i = 0; i < len; ++i) {
            if (ByteString.upperCase(a[i + aoff]) == ByteString.upperCase(b[i + boff])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof ByteString && this.equals((ByteString)obj);
    }

    public boolean equals(ByteString other) {
        int len = this.len;
        return this == other || other != null && len == other.len && ByteString.equals(this.bytes, this.offs, other.bytes, other.offs, len);
    }

    public boolean equalsIgnoreCase(ByteString other) {
        int len = this.len;
        return this == other || other != null && len == other.len && ByteString.equalsIgnoreCase(this.bytes, this.offs, other.bytes, other.offs, len);
    }

    public int toInt(int start) {
        int len = this.len;
        if (start >= len) {
            return 0;
        }
        byte[] bytes = this.bytes;
        int v = 0;
        for (int i = start + this.offs; i < len; ++i) {
            byte b = bytes[i];
            if (b < 48 || b > 57) {
                return v;
            }
            v = (v << 3) + (v << 1) + (b - 48);
        }
        return v;
    }

    public int toInt() {
        return this.toInt(0);
    }

    public long toLong(int start) {
        int len = this.len;
        if (start >= len) {
            return 0L;
        }
        byte[] bytes = this.bytes;
        long v = 0L;
        for (int i = start; i < len; ++i) {
            byte b = bytes[i];
            if (b < 48 || b > 57) {
                return v;
            }
            v = (v << 3) + (v << 1) + (long)(b - 48);
        }
        return v;
    }

    public long toLong() {
        return this.toLong(0);
    }

    private static int decimalCount(int val) {
        assert (val >= 0);
        if (val < 10) {
            return 1;
        }
        if (val < 100) {
            return 2;
        }
        if (val < 1000) {
            return 3;
        }
        if (val < 10000) {
            return 4;
        }
        if (val < 100000) {
            return 5;
        }
        if (val < 1000000) {
            return 6;
        }
        if (val < 10000000) {
            return 7;
        }
        if (val < 100000000) {
            return 8;
        }
        if (val < 1000000000) {
            return 9;
        }
        return 10;
    }

    private static int decimalCount(long val) {
        assert (val >= 0L);
        if (val < 10L) {
            return 1;
        }
        if (val < 100L) {
            return 2;
        }
        if (val < 1000L) {
            return 3;
        }
        if (val < 10000L) {
            return 4;
        }
        if (val < 100000L) {
            return 5;
        }
        if (val < 1000000L) {
            return 6;
        }
        if (val < 10000000L) {
            return 7;
        }
        if (val < 100000000L) {
            return 8;
        }
        if (val < 1000000000L) {
            return 9;
        }
        if (val < 10000000000L) {
            return 10;
        }
        if (val < 100000000000L) {
            return 11;
        }
        if (val < 1000000000000L) {
            return 12;
        }
        if (val < 10000000000000L) {
            return 13;
        }
        if (val < 100000000000000L) {
            return 14;
        }
        if (val < 1000000000000000L) {
            return 15;
        }
        if (val < 10000000000000000L) {
            return 16;
        }
        if (val < 100000000000000000L) {
            return 17;
        }
        if (val < 1000000000000000000L) {
            return 18;
        }
        return 19;
    }

    public static ByteString fromLong(long val) {
        byte[] b;
        if (val == 0L) {
            return ZERO;
        }
        int i = ByteString.decimalCount(Math.abs(val));
        if (val < 0L) {
            b = new byte[++i];
            b[0] = 45;
        } else {
            b = new byte[i];
        }
        do {
            long quo = val / 10L;
            int mod = (int)(val - ((quo << 3) + (quo << 1)));
            b[--i] = (byte)(mod + 48);
            val = quo;
        } while (i > 0);
        return new ByteString(b);
    }

    public static ByteString fromInt(int val) {
        byte[] b;
        if (val == 0) {
            return ZERO;
        }
        int i = ByteString.decimalCount(Math.abs(val));
        if (val < 0) {
            b = new byte[++i];
            b[0] = 45;
        } else {
            b = new byte[i];
        }
        do {
            int quo = val / 10;
            int mod = val - ((quo << 3) + (quo << 1));
            b[--i] = (byte)(mod + 48);
            val = quo;
        } while (i > 0);
        return new ByteString(b);
    }

    public boolean equalToString(String str) {
        if (str == null) {
            return false;
        }
        byte[] bytes = this.bytes;
        int length = bytes.length;
        if (str.length() != length) {
            return false;
        }
        int end = this.offs + this.len;
        for (int i = this.offs; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch <= '\u00ff' && bytes[i] == (byte)str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalToStringIgnoreCase(String str) {
        if (str == null) {
            return false;
        }
        byte[] bytes = this.bytes;
        int length = bytes.length;
        if (str.length() != length) {
            return false;
        }
        int end = this.offs + this.len;
        for (int i = this.offs; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch <= '\u00ff' && ByteString.upperCase(bytes[i]) == ByteString.upperCase((byte)ch)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(char c, int start) {
        if (c > '\u00ff') {
            return -1;
        }
        int len = this.len;
        if (start > len) {
            return -1;
        }
        start = Math.max(0, start) + this.offs;
        byte[] bytes = this.bytes;
        byte bc = (byte)c;
        int end = start + len;
        for (int i = start; i < end; ++i) {
            if (bytes[i] != bc) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.length() - 1);
    }

    public int lastIndexOf(char c, int start) {
        if (c > '\u00ff') {
            return -1;
        }
        byte[] bytes = this.bytes;
        int offs = this.offs;
        start = Math.min(start, this.len - 1) + offs;
        byte bc = (byte)c;
        for (int i = start; i >= offs; --i) {
            if (bytes[i] != bc) continue;
            return i;
        }
        return -1;
    }

    private static int arrayIndexOf(byte[] a, int aOffs, byte[] b, int bOffs, int bLen) {
        int aLen = a.length - aOffs;
        if (bLen > aLen || aLen < 0) {
            return -1;
        }
        aOffs = Math.max(0, aOffs);
        if (bLen == 0) {
            return aOffs;
        }
        byte startByte = b[bOffs];
        int limit = aLen - bLen;
        block0: for (int i = aOffs; i < limit; ++i) {
            if (a[i] != startByte) continue;
            for (int j = 1; j < bLen; ++j) {
                if (a[i + j] != b[j + bOffs]) continue block0;
            }
            return i;
        }
        return -1;
    }

    private static int arrayIndexOf(byte[] a, int aOffs, String string) {
        int aLen = a.length - aOffs;
        int bLen = string.length();
        if (bLen > aLen || aLen < 0) {
            return -1;
        }
        aOffs = Math.max(0, aOffs);
        if (bLen == 0) {
            return aOffs;
        }
        char startChar = string.charAt(0);
        if (startChar > '\u00ff') {
            return -1;
        }
        int limit = aLen - bLen;
        block0: for (int i = aOffs; i < limit; ++i) {
            if (a[i] != startChar) continue;
            for (int j = 1; j < bLen; ++j) {
                char ch = string.charAt(j);
                if (ch > '\u00ff') {
                    return -1;
                }
                if (a[i + j] != ch) continue block0;
            }
            return i;
        }
        return -1;
    }

    private static int arrayIndexOfIgnoreCase(byte[] a, int aOffs, byte[] b, int bOffs, int bLen) {
        int aLen = a.length - aOffs;
        if (bLen > aLen || aLen < 0) {
            return -1;
        }
        aOffs = Math.max(0, aOffs);
        if (bLen == 0) {
            return aOffs;
        }
        int startChar = ByteString.upperCase(b[bOffs]);
        int limit = aLen - bLen;
        block0: for (int i = aOffs; i < limit; ++i) {
            if (ByteString.upperCase(a[i]) != startChar) continue;
            for (int j = 1; j < bLen; ++j) {
                if (ByteString.upperCase(a[i + j]) != ByteString.upperCase(b[j + bOffs])) continue block0;
            }
            return i;
        }
        return -1;
    }

    private static int arrayIndexOfIgnoreCase(byte[] a, int aOffs, String string) {
        int aLen = a.length - aOffs;
        int bLen = string.length();
        if (bLen > aLen || aLen < 0) {
            return -1;
        }
        aOffs = Math.max(0, aOffs);
        if (bLen == 0) {
            return aOffs;
        }
        char startChar = string.charAt(0);
        if (startChar > '\u00ff') {
            return -1;
        }
        int startCP = ByteString.upperCase((byte)startChar);
        int limit = aLen - bLen;
        block0: for (int i = aOffs; i < limit; ++i) {
            if (ByteString.upperCase(a[i]) != startCP) continue;
            for (int j = 1; j < bLen; ++j) {
                char ch = string.charAt(j);
                if (ch > '\u00ff') {
                    return -1;
                }
                if (ByteString.upperCase(a[i + j]) != ByteString.upperCase((byte)ch)) continue block0;
            }
            return i;
        }
        return -1;
    }

    private static int arrayLastIndexOf(byte[] a, int aOffs, byte[] b, int bOffs, int bLen) {
        int aLen = a.length - aOffs;
        if (bLen > aLen || aLen < 0 || aOffs < 0) {
            return -1;
        }
        aOffs = Math.min(aLen - bLen, aOffs);
        if (bLen == 0) {
            return aOffs;
        }
        byte startByte = b[0];
        for (int i = aOffs - 1; i >= 0; --i) {
            int j;
            if (a[i] != startByte || (j = 1) >= bLen || a[i + j] != b[bOffs + j]) continue;
            return i;
        }
        return -1;
    }

    private static int arrayLastIndexOf(byte[] a, int aOffs, String string) {
        int aLen = a.length - aOffs;
        int bLen = string.length();
        if (bLen > aLen || aLen < 0 || aOffs < 0) {
            return -1;
        }
        aOffs = Math.min(aLen - bLen, aOffs);
        if (bLen == 0) {
            return aOffs;
        }
        char startChar = string.charAt(0);
        if (startChar > '\u00ff') {
            return -1;
        }
        byte startByte = (byte)startChar;
        for (int i = aOffs - 1; i >= 0; --i) {
            int j;
            if (a[i] != startByte || (j = 1) >= bLen) continue;
            char ch = string.charAt(j);
            if (ch > '\u00ff') {
                return -1;
            }
            if (a[i + j] != (byte)ch) continue;
            return i;
        }
        return -1;
    }

    private static int arrayLastIndexOfIgnoreCase(byte[] a, int aOffs, byte[] b, int bOffs, int bLen) {
        int aLen = a.length - aOffs;
        if (bLen > aLen || aLen < 0 || aOffs < 0) {
            return -1;
        }
        aOffs = Math.min(aLen - bLen, aOffs);
        if (bLen == 0) {
            return aOffs;
        }
        int startCP = ByteString.upperCase(b[bOffs]);
        for (int i = aOffs - 1; i >= 0; --i) {
            int j;
            if (ByteString.upperCase(a[i]) != startCP || (j = 1) >= bLen || ByteString.upperCase(a[i + j]) != ByteString.upperCase(b[j + bOffs])) continue;
            return i;
        }
        return -1;
    }

    private static int arrayLastIndexOfIgnoreCase(byte[] a, int aOffs, String string) {
        int aLen = a.length - aOffs;
        int bLen = string.length();
        if (bLen > aLen || aLen < 0 || aOffs < 0) {
            return -1;
        }
        aOffs = Math.min(aLen - bLen, aOffs);
        if (bLen == 0) {
            return aOffs;
        }
        char startChar = string.charAt(0);
        if (startChar > '\u00ff') {
            return -1;
        }
        int startCP = ByteString.upperCase((byte)startChar);
        for (int i = aOffs - 1; i >= 0; --i) {
            int j;
            if (ByteString.upperCase(a[i]) != startCP || (j = 1) >= bLen) continue;
            char ch = string.charAt(j);
            if (ch > '\u00ff') {
                return -1;
            }
            if (ByteString.upperCase(a[i + j]) != ByteString.upperCase((byte)ch)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(ByteString other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        byte[] otherBytes = other.bytes;
        return ByteString.arrayIndexOf(this.bytes, this.offs, otherBytes, other.offs, other.len) != -1;
    }

    public boolean contains(String other) {
        return other != null && this.toString().contains(other);
    }

    public boolean containsIgnoreCase(ByteString other) {
        return other == this || other != null && ByteString.arrayIndexOfIgnoreCase(this.bytes, this.offs, other.bytes, other.offs, other.len) != -1;
    }

    public boolean containsIgnoreCase(String other) {
        return ByteString.arrayIndexOfIgnoreCase(this.bytes, this.offs, other) != -1;
    }

    public int indexOf(ByteString other) {
        return ByteString.arrayIndexOf(this.bytes, this.offs, other.bytes, other.offs, other.len);
    }

    public int indexOf(ByteString other, int start) {
        if (start > this.len) {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        return ByteString.arrayIndexOf(this.bytes, this.offs + start, other.bytes, other.offs, other.len);
    }

    public int indexOf(String other) {
        return ByteString.arrayIndexOf(this.bytes, this.offs, other);
    }

    public int indexOf(String other, int start) {
        if (start > this.len) {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        return ByteString.arrayIndexOf(this.bytes, this.offs + start, other);
    }

    public int indexOfIgnoreCase(ByteString other) {
        return ByteString.arrayIndexOfIgnoreCase(this.bytes, this.offs, other.bytes, other.offs, other.len);
    }

    public int indexOfIgnoreCase(ByteString other, int start) {
        if (start > this.len) {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        return ByteString.arrayIndexOfIgnoreCase(this.bytes, this.offs + start, other.bytes, other.offs, other.len);
    }

    public int indexOfIgnoreCase(String other) {
        return ByteString.arrayIndexOfIgnoreCase(this.bytes, this.offs, other);
    }

    public int indexOfIgnoreCase(String other, int start) {
        if (start > this.len) {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        return ByteString.arrayIndexOfIgnoreCase(this.bytes, this.offs + start, other);
    }

    public int lastIndexOf(ByteString other) {
        return ByteString.arrayLastIndexOf(this.bytes, this.offs, other.bytes, other.offs, other.len);
    }

    public int lastIndexOf(ByteString other, int start) {
        if (start > this.len) {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        return ByteString.arrayLastIndexOf(this.bytes, this.offs + start, other.bytes, other.offs, other.len);
    }

    public int lastIndexOf(String other) {
        return ByteString.arrayLastIndexOf(this.bytes, this.offs, other);
    }

    public int lastIndexOf(String other, int start) {
        return ByteString.arrayLastIndexOf(this.bytes, this.offs + start, other);
    }

    public int lastIndexOfIgnoreCase(ByteString other) {
        return ByteString.arrayLastIndexOfIgnoreCase(this.bytes, this.offs, other.bytes, other.offs, other.len);
    }

    public int lastIndexOfIgnoreCase(ByteString other, int start) {
        if (start > this.len) {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        return ByteString.arrayLastIndexOfIgnoreCase(this.bytes, this.offs + start, other.bytes, other.offs, other.len);
    }

    public int lastIndexOfIgnoreCase(String other) {
        return ByteString.arrayLastIndexOfIgnoreCase(this.bytes, this.offs, other);
    }

    public int lastIndexOfIgnoreCase(String other, int start) {
        return ByteString.arrayLastIndexOfIgnoreCase(this.bytes, this.offs + start, other);
    }

    public boolean regionMatches(boolean ignoreCase, int offset, byte[] other, int otherOffset, int len) {
        if (offset < 0 || otherOffset < 0 || offset + len > this.len || otherOffset + len > other.length) {
            return false;
        }
        if (ignoreCase) {
            return ByteString.equalsIgnoreCase(this.bytes, offset + this.offs, other, otherOffset, len);
        }
        return ByteString.equals(this.bytes, offset + this.offs, other, otherOffset, len);
    }

    public boolean regionMatches(boolean ignoreCase, int offset, ByteString other, int otherOffset, int len) {
        if (offset < 0 || otherOffset < 0 || offset + len > this.len || otherOffset + len > other.len) {
            return false;
        }
        if (ignoreCase) {
            return ByteString.equalsIgnoreCase(this.bytes, offset + this.offs, other.bytes, otherOffset, len);
        }
        return ByteString.equals(this.bytes, offset + this.offs, other.bytes, otherOffset, len);
    }

    public boolean regionMatches(boolean ignoreCase, int offset, String other, int otherOffset, int len) {
        if (offset < 0 || otherOffset < 0 || offset + len > this.len || otherOffset + len > other.length()) {
            return false;
        }
        if (ignoreCase) {
            return ByteString.equalsIgnoreCase(this.bytes, offset + this.offs, other, otherOffset, len);
        }
        return ByteString.equals(this.bytes, offset + this.offs, other, otherOffset, len);
    }

    private static boolean equalsIgnoreCase(byte[] a, int aOffs, String string, int stringOffset, int length) {
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i + stringOffset);
            if (ch > '\u00ff') {
                return false;
            }
            if (a[i + aOffs] == (byte)ch) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(byte[] a, int aOffs, String string, int stringOffset, int length) {
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i + stringOffset);
            if (ch > '\u00ff') {
                return false;
            }
            if (ByteString.upperCase(a[i + aOffs]) == ByteString.upperCase((byte)ch)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(ByteString prefix) {
        return this.regionMatches(false, 0, prefix, 0, prefix.length());
    }

    public boolean startsWith(String prefix) {
        return this.regionMatches(false, 0, prefix, 0, prefix.length());
    }

    public boolean startsWith(char prefix) {
        return prefix <= '\u00ff' && this.len > 0 && this.bytes[this.offs] == (byte)prefix;
    }

    public boolean startsWithIgnoreCase(ByteString prefix) {
        return this.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public boolean startsWithIgnoreCase(String prefix) {
        return this.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public boolean startsWithIgnoreCase(char prefix) {
        return prefix <= '\u00ff' && this.len > 0 && ByteString.upperCase(this.bytes[this.offs]) == ByteString.upperCase((byte)prefix);
    }

    public boolean endsWith(ByteString suffix) {
        int suffixLength = suffix.len;
        return this.regionMatches(false, this.len - suffixLength, suffix, 0, suffixLength);
    }

    public boolean endsWith(String suffix) {
        int suffixLength = suffix.length();
        return this.regionMatches(false, this.len - suffixLength, suffix, 0, suffixLength);
    }

    public boolean endsWith(char suffix) {
        int len = this.len;
        return suffix <= '\u00ff' && len > 0 && this.bytes[this.offs + len - 1] == (byte)suffix;
    }

    public boolean endsWithIgnoreCase(ByteString suffix) {
        int suffixLength = suffix.length();
        return this.regionMatches(true, this.len - suffixLength, suffix, 0, suffixLength);
    }

    public boolean endsWithIgnoreCase(String suffix) {
        int suffixLength = suffix.length();
        return this.regionMatches(true, this.len - suffixLength, suffix, 0, suffixLength);
    }

    public boolean endsWithIgnoreCase(char suffix) {
        int len = this.len;
        return suffix <= '\u00ff' && len > 0 && ByteString.upperCase(this.bytes[this.offs + len - 1]) == ByteString.upperCase((byte)suffix);
    }

    public ByteString concat(byte[] suffixBytes) {
        return this.concat(suffixBytes, 0, suffixBytes.length);
    }

    public ByteString concat(byte[] suffixBytes, int offs, int len) {
        if (len <= 0) {
            return this;
        }
        int length = this.len;
        byte[] newBytes = Arrays.copyOfRange(this.bytes, this.offs, length + len);
        System.arraycopy(suffixBytes, offs, newBytes, length, len);
        return new ByteString(newBytes);
    }

    public ByteString concat(ByteString suffix) {
        return this.concat(suffix.bytes, suffix.offs, suffix.len);
    }

    public ByteString concat(ByteString suffix, int offs, int len) {
        return this.concat(suffix.bytes, offs + suffix.offs, Math.min(len, suffix.len));
    }

    public ByteString concat(String suffix) {
        return this.concat(suffix, 0, suffix.length());
    }

    private static byte[] getStringBytes(boolean trust, byte[] dst, int dstOffs, String src, int srcOffs, int len) {
        if (trust) {
            src.getBytes(srcOffs, srcOffs + len, dst, dstOffs);
        } else {
            for (int i = srcOffs; i < len; ++i) {
                char c = src.charAt(i);
                if (c > '\u00ff') {
                    throw new IllegalArgumentException("Invalid string contents");
                }
                dst[i + dstOffs] = (byte)c;
            }
        }
        return dst;
    }

    public ByteString concat(String suffix, int offs, int len) {
        if (len <= 0) {
            return this;
        }
        byte[] bytes = this.bytes;
        int length = this.len;
        byte[] newBytes = Arrays.copyOfRange(bytes, offs, offs + length + len);
        ByteString.getStringBytes(false, newBytes, length, suffix, offs, len);
        return new ByteString(newBytes);
    }

    public static ByteString concat(String prefix, ByteString suffix) {
        int prefixLength = prefix.length();
        byte[] suffixBytes = suffix.bytes;
        int suffixLength = suffixBytes.length;
        byte[] newBytes = new byte[prefixLength + suffixLength];
        ByteString.getStringBytes(false, newBytes, 0, prefix, 0, prefixLength);
        System.arraycopy(suffixBytes, suffix.offs, newBytes, prefixLength, suffixLength);
        return new ByteString(newBytes);
    }

    public static ByteString concat(String prefix, String suffix) {
        int prefixLength = prefix.length();
        int suffixLength = suffix.length();
        byte[] newBytes = new byte[prefixLength + suffixLength];
        ByteString.getStringBytes(false, newBytes, 0, prefix, 0, prefixLength);
        ByteString.getStringBytes(false, newBytes, prefixLength, suffix, 0, suffixLength);
        return new ByteString(newBytes);
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index > this.len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (char)(this.bytes[index + this.offs] & 0xFF);
    }

    @Override
    public ByteString subSequence(int start, int end) {
        return this.substring(start, end);
    }
}

