/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import infinispan.org.jboss.as.controller.registry.OperationEntry;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MultistepUtil {
    private MultistepUtil() {
    }

    public static void recordOperationSteps(OperationContext context, List<ModelNode> operations, List<ModelNode> responses) throws OperationFailedException {
        assert (responses.isEmpty() || operations.size() == responses.size());
        boolean responsesProvided = !responses.isEmpty();
        LinkedHashMap<Integer, ModelNode> operationMap = new LinkedHashMap<Integer, ModelNode>();
        LinkedHashMap<Integer, ModelNode> responseMap = new LinkedHashMap<Integer, ModelNode>();
        int i = 0;
        for (ModelNode op : operations) {
            operationMap.put(i, op);
            if (responsesProvided) {
                ModelNode response = responses.get(i);
                assert (response != null) : "No response provided for " + i;
                responseMap.put(i, response);
            }
            ++i;
        }
        MultistepUtil.recordOperationSteps(context, operationMap, responseMap, OperationHandlerResolver.DEFAULT, false);
        if (!responsesProvided) {
            for (ModelNode response : responseMap.values()) {
                responses.add(response);
            }
        }
    }

    public static <T> void recordOperationSteps(OperationContext context, Map<T, ModelNode> operations, Map<T, ModelNode> responses) throws OperationFailedException {
        MultistepUtil.recordOperationSteps(context, operations, responses, OperationHandlerResolver.DEFAULT, false);
    }

    public static <T> void recordOperationSteps(OperationContext context, Map<T, ModelNode> operations, Map<T, ModelNode> responses, OperationHandlerResolver handlerResolver, boolean adjustAddresses) throws OperationFailedException {
        assert (responses != null);
        assert (responses.isEmpty() || operations.size() == responses.size());
        boolean responsesProvided = !responses.isEmpty();
        PathAddress currentAddress = adjustAddresses ? context.getCurrentAddress() : null;
        ArrayList<OpData> opdatas = new ArrayList<OpData>();
        for (Map.Entry<T, ModelNode> entry : operations.entrySet()) {
            ModelNode response;
            ModelNode modelNode = response = responsesProvided ? responses.get(entry.getKey()) : new ModelNode();
            assert (response != null) : "No response provided for " + entry.getValue();
            ModelNode op = entry.getValue();
            PathAddress stepAddress = PathAddress.pathAddress(op.get("address"));
            if (adjustAddresses) {
                stepAddress = currentAddress.append(stepAddress);
                op.get("address").set(stepAddress.toModelNode());
            }
            OperationStepHandler osh = MultistepUtil.getOsh(context, op, stepAddress, handlerResolver);
            opdatas.add(0, new OpData(op, osh, response));
            if (responsesProvided) continue;
            responses.put(entry.getKey(), response);
        }
        for (OpData opData : opdatas) {
            context.addStep(opData.response, opData.operation, opData.handler, OperationContext.Stage.MODEL, true);
        }
    }

    private static OperationStepHandler getOsh(OperationContext context, ModelNode subOperation, PathAddress stepAddress, OperationHandlerResolver handlerResolver) throws OperationFailedException {
        String stepOpName;
        ImmutableManagementResourceRegistration registry = context.getRootResourceRegistration();
        OperationEntry operationEntry = registry.getOperationEntry(stepAddress, stepOpName = subOperation.require("operation").asString());
        if (operationEntry == null) {
            ImmutableManagementResourceRegistration child = registry.getSubModel(stepAddress);
            if (child == null) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(stepAddress));
            }
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(stepOpName, stepAddress));
        }
        return handlerResolver.getOperationStepHandler(stepOpName, stepAddress, subOperation, operationEntry);
    }

    public static interface OperationHandlerResolver {
        public static final OperationHandlerResolver DEFAULT = new OperationHandlerResolver(){};

        default public OperationStepHandler getOperationStepHandler(String operationName, PathAddress address, ModelNode operation, OperationEntry operationEntry) {
            return operationEntry.getOperationHandler();
        }
    }

    private static class OpData {
        private final ModelNode operation;
        private final OperationStepHandler handler;
        private final ModelNode response;

        private OpData(ModelNode operation, OperationStepHandler handler, ModelNode response) {
            this.operation = operation;
            this.handler = handler;
            this.response = response;
        }
    }
}

