/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.global;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.access.Action;
import infinispan.org.jboss.as.controller.access.AuthorizationResult;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.common.Util;
import infinispan.org.jboss.as.controller.operations.global.FilteredData;
import infinispan.org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import infinispan.org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import infinispan.org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import infinispan.org.jboss.as.controller.registry.Resource;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ReadChildrenNamesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-children-names", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.CHILD_TYPE).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static final OperationStepHandler INSTANCE = new ReadChildrenNamesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String childType = GlobalOperationAttributes.CHILD_TYPE.resolveModelAttribute(context, operation).asString();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Map<String, Set<String>> childAddresses = GlobalOperationHandlers.getChildAddresses(context, address, registry, resource, childType);
        Set<String> childNames = childAddresses.get(childType);
        if (childNames == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.unknownChildType(childType));
        }
        childNames = new TreeSet<String>(childNames);
        ModelNode result = context.getResult();
        result.setEmptyList();
        PathAddress childAddress = address.append(PathElement.pathElement(childType));
        ModelNode op = Util.createEmptyOperation("read-resource", childAddress);
        op.get("operation-headers").set(operation.get("operation-headers"));
        ModelNode opAddr = op.get("address");
        ModelNode childProperty = opAddr.require(address.size());
        EnumSet<Action.ActionEffect> actionEffects = EnumSet.of(Action.ActionEffect.ADDRESS);
        FilteredData fd = null;
        for (String childName : childNames) {
            childProperty.set(childType, new ModelNode(childName));
            if (context.authorize(op, actionEffects).getDecision() == AuthorizationResult.Decision.PERMIT) {
                result.add(childName);
                continue;
            }
            if (fd == null) {
                fd = new FilteredData(address);
            }
            fd.addAccessRestrictedResource(childAddress);
        }
        if (fd != null) {
            context.getResponseHeaders().get("access-control").set(fd.toModelNode());
        }
    }
}

