/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import infinispan.org.jboss.logging.BasicLogger;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.commons.logging.BasicLogFactory;

@Immutable
public class PingOperation
extends HotRodOperation {
    private static final BasicLogger log = BasicLogFactory.getLog(PingOperation.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Transport transport;

    public PingOperation(Codec codec, AtomicInteger topologyId, Transport transport) {
        this(codec, topologyId, transport, DEFAULT_CACHE_NAME_BYTES);
    }

    public PingOperation(Codec codec, AtomicInteger topologyId, Transport transport, byte[] cacheName) {
        super(codec, 0, cacheName, topologyId);
        this.transport = transport;
    }

    public PingResult execute() {
        try {
            HeaderParams params = this.writeHeader(this.transport, (short)23);
            this.transport.flush();
            short respStatus = this.readHeaderAndValidate(this.transport, params);
            if (HotRodConstants.isSuccess(respStatus)) {
                if (trace) {
                    log.tracef("Successfully validated transport: %s", (Object)this.transport);
                }
                return HotRodConstants.hasCompatibility(respStatus) ? PingResult.SUCCESS_WITH_COMPAT : PingResult.SUCCESS;
            }
            String hexStatus = Integer.toHexString(respStatus);
            if (trace) {
                log.tracef("Unknown response status: %s", (Object)hexStatus);
            }
            throw new InvalidResponseException("Unexpected response status: " + hexStatus);
        }
        catch (HotRodClientException e) {
            if (e.getMessage().contains("CacheNotFoundException")) {
                return PingResult.CACHE_DOES_NOT_EXIST;
            }
            throw e;
        }
    }

    public static enum PingResult {
        SUCCESS,
        SUCCESS_WITH_COMPAT,
        CACHE_DOES_NOT_EXIST,
        FAIL;


        public boolean isSuccess() {
            return this == SUCCESS || this == SUCCESS_WITH_COMPAT;
        }

        public boolean hasCompatibility() {
            return this == SUCCESS_WITH_COMPAT;
        }
    }
}

