/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.client.helpers.standalone.impl;

import infinispan.org.jboss.as.controller.client.Operation;
import infinispan.org.jboss.as.controller.client.OperationBuilder;
import infinispan.org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import infinispan.org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import infinispan.org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import infinispan.org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import infinispan.org.jboss.as.controller.client.helpers.standalone.impl.DeploymentActionImpl;
import infinispan.org.jboss.as.controller.client.helpers.standalone.impl.DeploymentPlanImpl;
import infinispan.org.jboss.as.controller.client.helpers.standalone.impl.InitialDeploymentPlanBuilderFactory;
import infinispan.org.jboss.as.controller.client.helpers.standalone.impl.ServerDeploymentPlanResultFuture;
import infinispan.org.jboss.as.controller.client.logging.ControllerClientLogger;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.concurrent.Future;

public abstract class AbstractServerDeploymentManager
implements ServerDeploymentManager {
    protected AbstractServerDeploymentManager() {
    }

    @Override
    public InitialDeploymentPlanBuilder newDeploymentPlan() {
        return InitialDeploymentPlanBuilderFactory.newInitialDeploymentPlanBuilder();
    }

    @Override
    public Future<ServerDeploymentPlanResult> execute(DeploymentPlan plan) {
        if (!(plan instanceof DeploymentPlanImpl)) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotUseDeploymentPlan();
        }
        DeploymentPlanImpl planImpl = (DeploymentPlanImpl)plan;
        Operation operation = this.getCompositeOperation(planImpl);
        Future<ModelNode> nodeFuture = this.executeOperation(operation);
        return new ServerDeploymentPlanResultFuture(planImpl, nodeFuture);
    }

    protected abstract Future<ModelNode> executeOperation(Operation var1);

    private Operation getCompositeOperation(DeploymentPlanImpl plan) {
        ModelNode op = new ModelNode();
        op.get("operation").set("composite");
        op.get("address").setEmptyList();
        ModelNode steps = op.get("steps");
        steps.setEmptyList();
        op.get("operation-headers", "rollback-on-runtime-failure").set(plan.isGlobalRollback());
        OperationBuilder builder = new OperationBuilder(op);
        int stream = 0;
        for (DeploymentActionImpl action : plan.getDeploymentActionImpls()) {
            ModelNode step = new ModelNode();
            String uniqueName = action.getDeploymentUnitUniqueName();
            switch (action.getType()) {
                case ADD: {
                    this.configureDeploymentOperation(step, "add", uniqueName);
                    step.get("runtime-name").set(action.getNewContentFileName());
                    builder.addInputStream(action.getContentStream());
                    step.get("content").get(0).get("input-stream-index").set(stream++);
                    break;
                }
                case DEPLOY: {
                    this.configureDeploymentOperation(step, "deploy", uniqueName);
                    break;
                }
                case FULL_REPLACE: {
                    step.get("operation").set("full-replace-deployment");
                    step.get("address").setEmptyList();
                    step.get("name").set(uniqueName);
                    step.get("runtime-name").set(action.getNewContentFileName());
                    builder.addInputStream(action.getContentStream());
                    step.get("content").get(0).get("input-stream-index").set(stream++);
                    break;
                }
                case REDEPLOY: {
                    this.configureDeploymentOperation(step, "redeploy", uniqueName);
                    break;
                }
                case REMOVE: {
                    this.configureDeploymentOperation(step, "remove", uniqueName);
                    break;
                }
                case REPLACE: {
                    step.get("operation").set("replace-deployment");
                    step.get("address").setEmptyList();
                    step.get("name").set(uniqueName);
                    step.get("to-replace").set(action.getReplacedDeploymentUnitUniqueName());
                    break;
                }
                case UNDEPLOY: {
                    this.configureDeploymentOperation(step, "undeploy", uniqueName);
                    break;
                }
                default: {
                    throw ControllerClientLogger.ROOT_LOGGER.unknownActionType((Object)action.getType());
                }
            }
            steps.add(step);
        }
        return builder.build();
    }

    private void configureDeploymentOperation(ModelNode op, String operationName, String uniqueName) {
        op.get("operation").set(operationName);
        op.get("address").add("deployment", uniqueName);
    }
}

