/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.global;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import infinispan.org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.Set;
import java.util.TreeSet;

public class ReadChildrenTypesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-children-types", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.INCLUDE_ALIASES, GlobalOperationAttributes.INCLUDE_SINGLETONS).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static final OperationStepHandler INSTANCE = new ReadChildrenTypesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        if (registry == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(context.getCurrentAddress()));
        }
        boolean aliases = GlobalOperationAttributes.INCLUDE_ALIASES.resolveModelAttribute(context, operation).asBoolean(false);
        boolean singletons = GlobalOperationAttributes.INCLUDE_SINGLETONS.resolveModelAttribute(context, operation).asBoolean(false);
        Set<PathElement> childTypes = registry.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        TreeSet<String> children = new TreeSet<String>();
        for (PathElement child : childTypes) {
            boolean isSingletonResource;
            PathAddress relativeAddr = PathAddress.pathAddress(child);
            ImmutableManagementResourceRegistration childReg = registry.getSubModel(relativeAddr);
            boolean bl = isSingletonResource = childReg == null || !child.isWildcard();
            if (childReg.isAlias() && !aliases) continue;
            if (singletons && isSingletonResource) {
                children.add(child.getKey() + '=' + child.getValue());
                continue;
            }
            children.add(child.getKey());
        }
        ModelNode result = context.getResult();
        result.setEmptyList();
        for (String child : children) {
            result.add(child);
        }
    }
}

