/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.validation;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import infinispan.org.jboss.as.controller.operations.validation.ModelTypeValidator;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectTypeValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final Map<String, AttributeDefinition> allowedValues;
    private final List<ModelNode> nodeValues;

    public ObjectTypeValidator(boolean nullable, AttributeDefinition ... attributes) {
        super(nullable, true, false, ModelType.OBJECT, new ModelType[0]);
        this.allowedValues = new HashMap<String, AttributeDefinition>(attributes.length);
        this.nodeValues = new ArrayList<ModelNode>(attributes.length);
        for (AttributeDefinition attribute : attributes) {
            this.allowedValues.put(attribute.getName(), attribute);
            this.nodeValues.add(new ModelNode(attribute.getName()));
        }
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            for (String key : value.keys()) {
                if (this.allowedValues.containsKey(key)) {
                    this.allowedValues.get(key).getValidator().validateParameter(key, value.get(key));
                    continue;
                }
                throw ControllerLogger.ROOT_LOGGER.invalidKeyForObjectType(key, parameterName);
            }
        }
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        return this.nodeValues;
    }
}

