/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.AttributeMarshaller;
import infinispan.org.jboss.as.controller.parsing.Attribute;
import infinispan.org.jboss.dmr.ModelNode;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public interface AttributeMarshallers {

    public static class PropertiesAttributeMarshaller
    extends AttributeMarshaller {
        private final String wrapperElement;
        private final String elementName;
        private final boolean wrapElement;

        public PropertiesAttributeMarshaller(String wrapperElement, String elementName, boolean wrapElement) {
            this.wrapperElement = wrapperElement;
            this.elementName = elementName == null ? "property" : elementName;
            this.wrapElement = wrapElement;
        }

        public PropertiesAttributeMarshaller(String wrapperElement, boolean wrapElement) {
            this(wrapperElement, null, wrapElement);
        }

        public PropertiesAttributeMarshaller() {
            this(null, null, true);
        }

        @Override
        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
            return resourceModel.isDefined() && resourceModel.hasDefined(attribute.getName());
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (!resourceModel.hasDefined(attribute.getName())) {
                return;
            }
            resourceModel = resourceModel.get(attribute.getName());
            if (this.wrapElement) {
                writer.writeStartElement(this.wrapperElement == null ? attribute.getName() : this.wrapperElement);
            }
            for (ModelNode property : resourceModel.asList()) {
                writer.writeEmptyElement(this.elementName);
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.asProperty().getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), property.asProperty().getValue().asString());
            }
            if (this.wrapElement) {
                writer.writeEndElement();
            }
        }

        @Override
        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            this.marshallAsElement(attribute, resourceModel, marshallDefault, writer);
        }

        @Override
        public boolean isMarshallableAsElement() {
            return true;
        }
    }
}

