/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.transform;

import infinispan.org.jboss.as.controller.ExpressionResolver;
import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.ProcessType;
import infinispan.org.jboss.as.controller.RunningMode;
import infinispan.org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import infinispan.org.jboss.as.controller.registry.Resource;
import infinispan.org.jboss.as.controller.transform.OperationTransformer;
import infinispan.org.jboss.as.controller.transform.ResourceTransformationContext;
import infinispan.org.jboss.as.controller.transform.ResourceTransformationContextImpl;
import infinispan.org.jboss.as.controller.transform.TransformationContext;
import infinispan.org.jboss.as.controller.transform.TransformationTarget;
import infinispan.org.jboss.as.controller.transform.TransformationTargetImpl;
import infinispan.org.jboss.as.controller.transform.TransformerOperationAttachment;
import infinispan.org.jboss.as.controller.transform.TransformersImpl;
import infinispan.org.jboss.dmr.ModelNode;

public interface Transformers {
    public static final ResourceIgnoredTransformationRegistry DEFAULT = new ResourceIgnoredTransformationRegistry(){

        @Override
        public boolean isResourceTransformationIgnored(PathAddress address) {
            return false;
        }
    };

    public TransformationTarget getTarget();

    public OperationTransformer.TransformedOperation transformOperation(TransformationContext var1, ModelNode var2) throws OperationFailedException;

    public OperationTransformer.TransformedOperation transformOperation(TransformationInputs var1, ModelNode var2) throws OperationFailedException;

    public Resource transformResource(ResourceTransformationContext var1, Resource var2) throws OperationFailedException;

    public Resource transformRootResource(TransformationInputs var1, Resource var2) throws OperationFailedException;

    public Resource transformRootResource(TransformationInputs var1, Resource var2, ResourceIgnoredTransformationRegistry var3) throws OperationFailedException;

    public static interface ResourceIgnoredTransformationRegistry {
        public boolean isResourceTransformationIgnored(PathAddress var1);
    }

    public static class Factory {
        private Factory() {
        }

        public static Transformers create(TransformationTarget target) {
            return new TransformersImpl(target);
        }

        public static ResourceTransformationContext create(TransformationTarget target, Resource model, ImmutableManagementResourceRegistration registration, ExpressionResolver resolver, RunningMode runningMode, ProcessType type, TransformerOperationAttachment attachment) {
            return ResourceTransformationContextImpl.create(target, model, registration, runningMode, type, attachment, DEFAULT);
        }

        public static ResourceTransformationContext create(TransformationTarget target, Resource model, ImmutableManagementResourceRegistration registration, ExpressionResolver resolver, RunningMode runningMode, ProcessType type, TransformerOperationAttachment attachment, ResourceIgnoredTransformationRegistry ignoredTransformationRegistry) {
            return ResourceTransformationContextImpl.create(target, model, registration, runningMode, type, attachment, ignoredTransformationRegistry);
        }

        public static Transformers createLocal() {
            return new TransformersImpl(TransformationTargetImpl.createLocal());
        }
    }

    public static class TransformationInputs {
        private static final OperationContext.AttachmentKey<TransformationInputs> KEY = OperationContext.AttachmentKey.create(TransformationInputs.class);
        private final Resource originalModel;
        private final ImmutableManagementResourceRegistration registration;
        private final ProcessType processType;
        private final RunningMode runningMode;
        private final TransformerOperationAttachment transformerOperationAttachment;

        public static TransformationInputs getOrCreate(OperationContext context) {
            TransformationInputs result;
            if (context.getCurrentStage() == OperationContext.Stage.DOMAIN) {
                result = context.getAttachment(KEY);
                if (result == null) {
                    result = new TransformationInputs(context);
                    context.attach(KEY, result);
                }
            } else {
                result = new TransformationInputs(context);
            }
            return result;
        }

        public TransformationInputs(OperationContext context) {
            this.originalModel = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true);
            this.registration = context.getRootResourceRegistration();
            this.processType = context.getProcessType();
            this.runningMode = context.getRunningMode();
            this.transformerOperationAttachment = context.getAttachment(TransformerOperationAttachment.KEY);
        }

        public Resource getRootResource() {
            return this.originalModel;
        }

        public ImmutableManagementResourceRegistration getRootRegistration() {
            return this.registration;
        }

        public ProcessType getProcessType() {
            return this.processType;
        }

        public RunningMode getRunningMode() {
            return this.runningMode;
        }

        public TransformerOperationAttachment getTransformerOperationAttachment() {
            return this.transformerOperationAttachment;
        }
    }
}

