/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules.filter;

import infinispan.org.jboss.modules.filter.PathFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GlobPathFilter
implements PathFilter {
    private static final Pattern GLOB_PATTERN = Pattern.compile("(\\*\\*?)|(\\?)|(\\\\.)|(/+)|([^*?]+)");
    private final String glob;
    private final Pattern pattern;

    GlobPathFilter(String glob) {
        this.pattern = GlobPathFilter.getGlobPattern(glob);
        this.glob = glob;
    }

    @Override
    public boolean accept(String path) {
        return this.pattern.matcher(path).matches();
    }

    private static Pattern getGlobPattern(String glob) {
        StringBuilder patternBuilder = new StringBuilder();
        Matcher m = GLOB_PATTERN.matcher(glob);
        boolean lastWasSlash = false;
        while (m.find()) {
            lastWasSlash = false;
            String grp = m.group(1);
            if (grp != null) {
                if (grp.length() == 2) {
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append("[^/]*");
                continue;
            }
            grp = m.group(2);
            if (grp != null) {
                patternBuilder.append("[^/]");
                continue;
            }
            grp = m.group(3);
            if (grp != null) {
                patternBuilder.append(Pattern.quote(m.group().substring(1)));
                continue;
            }
            grp = m.group(4);
            if (grp != null) {
                patternBuilder.append("/+");
                lastWasSlash = true;
                continue;
            }
            patternBuilder.append(Pattern.quote(m.group()));
        }
        if (lastWasSlash) {
            patternBuilder.append(".*");
        } else {
            patternBuilder.append("(?:/.*)?");
        }
        return Pattern.compile(patternBuilder.toString());
    }

    @Override
    public int hashCode() {
        return this.glob.hashCode() + 13;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GlobPathFilter && this.equals((GlobPathFilter)obj);
    }

    public boolean equals(GlobPathFilter obj) {
        return obj != null && obj.pattern.equals(this.pattern);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("match ");
        if (this.glob != null) {
            b.append('\"').append(this.glob).append('\"');
        } else {
            b.append('/').append(this.pattern).append('/');
        }
        return b.toString();
    }
}

