/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.access;

import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.security.ControllerPermission;
import infinispan.org.jboss.as.core.security.AccountPrincipal;
import infinispan.org.jboss.as.core.security.GroupPrincipal;
import infinispan.org.jboss.as.core.security.RealmPrincipal;
import infinispan.org.jboss.as.core.security.RolePrincipal;
import java.security.Permission;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

public final class Caller {
    private static final String UNDEFINED = "UNDEFINED";
    private final Subject subject;
    private volatile String name;
    private volatile String realm = "UNDEFINED";
    private volatile Set<String> groups;
    private volatile Set<String> roles;

    private Caller(Subject subject) {
        this.subject = subject;
    }

    public static Caller createCaller(Subject subject) {
        Caller.checkPermission(ControllerPermission.CREATE_CALLER);
        return new Caller(subject);
    }

    public String getName() {
        if (this.name == null && this.subject != null) {
            Set<AccountPrincipal> accounts = this.subject.getPrincipals(AccountPrincipal.class);
            if (accounts.size() == 1) {
                this.name = accounts.iterator().next().getName();
            } else if (accounts.size() >= 1) {
                throw ControllerLogger.ROOT_LOGGER.unexpectedAccountPrincipalCount(accounts.size());
            }
        }
        return this.name;
    }

    public String getRealm() {
        if (UNDEFINED.equals(this.realm)) {
            if (this.subject != null) {
                Set<RealmPrincipal> realmPrincipals = this.subject.getPrincipals(RealmPrincipal.class);
                String foundRealm = null;
                for (RealmPrincipal current : realmPrincipals) {
                    if (foundRealm == null) {
                        foundRealm = current.getRealm();
                        continue;
                    }
                    if (foundRealm.equals(current.getRealm())) continue;
                    throw ControllerLogger.ROOT_LOGGER.differentRealmsInSubject(foundRealm, current.getRealm());
                }
                this.realm = foundRealm;
            } else {
                this.realm = null;
            }
        }
        return this.realm;
    }

    public Set<String> getAssociatedGroups() {
        if (this.groups == null) {
            if (this.subject != null) {
                Set<GroupPrincipal> groupPrincipals = this.subject.getPrincipals(GroupPrincipal.class);
                HashSet<String> groups = new HashSet<String>(groupPrincipals.size());
                for (Principal principal : groupPrincipals) {
                    groups.add(principal.getName());
                }
                this.groups = Collections.unmodifiableSet(groups);
            } else {
                this.groups = Collections.emptySet();
            }
        }
        return this.groups;
    }

    public Set<String> getAssociatedRoles() {
        if (this.roles == null) {
            if (this.subject != null) {
                Set<RolePrincipal> rolePrincipals = this.subject.getPrincipals(RolePrincipal.class);
                HashSet<String> roles = new HashSet<String>(rolePrincipals.size());
                for (Principal principal : rolePrincipals) {
                    roles.add(principal.getName());
                }
                this.roles = Collections.unmodifiableSet(roles);
            } else {
                this.roles = Collections.emptySet();
            }
        }
        return this.roles;
    }

    public boolean hasSubject() {
        return this.subject != null;
    }

    public Subject getSubject() {
        Caller.checkPermission(ControllerPermission.GET_CALLER_SUBJECT);
        return this.subject;
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

