/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.client.helpers;

import infinispan.org.jboss.as.controller.client.ModelControllerClient;
import infinispan.org.jboss.as.controller.client.Operation;
import infinispan.org.jboss.as.controller.client.OperationMessageHandler;
import infinispan.org.jboss.as.controller.client.OperationResponse;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.threads.AsyncFuture;
import java.io.IOException;

public class DelegatingModelControllerClient
implements ModelControllerClient {
    private final DelegateProvider provider;

    public DelegatingModelControllerClient(final ModelControllerClient delegate) {
        this(new DelegateProvider(){

            @Override
            public ModelControllerClient getDelegate() {
                return delegate;
            }
        });
    }

    public DelegatingModelControllerClient(DelegateProvider provider) {
        this.provider = provider;
    }

    @Override
    public ModelNode execute(ModelNode operation) throws IOException {
        return this.provider.getDelegate().execute(operation);
    }

    @Override
    public ModelNode execute(Operation operation) throws IOException {
        return this.provider.getDelegate().execute(operation);
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.provider.getDelegate().execute(operation, messageHandler);
    }

    @Override
    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.provider.getDelegate().execute(operation, messageHandler);
    }

    @Override
    public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.provider.getDelegate().executeOperation(operation, messageHandler);
    }

    @Override
    public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.provider.getDelegate().executeAsync(operation, messageHandler);
    }

    @Override
    public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.provider.getDelegate().executeAsync(operation, messageHandler);
    }

    @Override
    public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.provider.getDelegate().executeOperationAsync(operation, messageHandler);
    }

    @Override
    public void close() throws IOException {
        this.provider.getDelegate().close();
    }

    public static interface DelegateProvider {
        public ModelControllerClient getDelegate();
    }
}

