/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.common;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinition;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.validation.ModelTypeValidator;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import infinispan.org.jboss.dmr.Property;

public class NamespaceRemoveHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "remove-namespace";
    private static final SimpleAttributeDefinition NAMESPACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("namespace", ModelType.STRING).setAllowNull(false)).setValidator(new ModelTypeValidator(ModelType.STRING, false))).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("remove-namespace", ControllerResolver.getResolver("namespaces")).setParameters(NAMESPACE).build();
    public static final NamespaceRemoveHandler INSTANCE = new NamespaceRemoveHandler();

    private NamespaceRemoveHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode param = NAMESPACE.resolveModelAttribute(context, operation);
        ModelNode namespaces = model.get("namespaces");
        Property toRemove = null;
        ModelNode newList = new ModelNode().setEmptyList();
        String prefix = param.asString();
        if (namespaces.isDefined()) {
            for (Property namespace : namespaces.asPropertyList()) {
                if (prefix.equals(namespace.getName())) {
                    toRemove = namespace;
                    continue;
                }
                newList.add(namespace.getName(), namespace.getValue());
            }
        }
        if (toRemove == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.namespaceNotFound(prefix));
        }
        namespaces.set(newList);
    }
}

