/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.protocol.mgmt;

import infinispan.org.jboss.as.protocol.logging.ProtocolLogger;
import infinispan.org.jboss.as.protocol.mgmt.ActiveOperation;
import infinispan.org.jboss.as.protocol.mgmt.ManagementBatchIdManager;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import infinispan.org.jboss.remoting3.Channel;
import infinispan.org.jboss.threads.AsyncFuture;
import infinispan.org.jboss.threads.AsyncFutureTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.xnio.Cancellable;

class ActiveOperationSupport {
    private static final Executor directExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    private static final ActiveOperation.CompletedCallback<?> NO_OP_CALLBACK = new ActiveOperation.CompletedCallback<Object>(){

        @Override
        public void completed(Object result) {
        }

        @Override
        public void failed(Exception e) {
        }

        @Override
        public void cancelled() {
        }
    };
    private final ConcurrentMap<Integer, ActiveOperationImpl<?, ?>> activeRequests = new ConcurrentHashMap(16, 0.75f, Runtime.getRuntime().availableProcessors());
    private final ManagementBatchIdManager operationIdManager = new ManagementBatchIdManager.DefaultManagementBatchIdManager();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private int activeCount = 0;
    private volatile boolean shutdown = false;
    private static final List<Cancellable> CANCEL_REQUESTED = Collections.emptyList();

    protected ActiveOperationSupport() {
    }

    static <T> ActiveOperation.CompletedCallback<T> getDefaultCallback() {
        return NO_OP_CALLBACK;
    }

    static <T> ActiveOperation.CompletedCallback<T> getCheckedCallback(ActiveOperation.CompletedCallback<T> callback) {
        if (callback == null) {
            return ActiveOperationSupport.getDefaultCallback();
        }
        return callback;
    }

    protected <T, A> ActiveOperation<T, A> registerActiveOperation(A attachment) {
        ActiveOperation.CompletedCallback<T> callback = ActiveOperationSupport.getDefaultCallback();
        return this.registerActiveOperation(attachment, callback);
    }

    protected <T, A> ActiveOperation<T, A> registerActiveOperation(A attachment, ActiveOperation.CompletedCallback<T> callback) {
        return this.registerActiveOperation(null, attachment, callback);
    }

    protected <T, A> ActiveOperation<T, A> registerActiveOperation(Integer id, A attachment) {
        ActiveOperation.CompletedCallback<T> callback = ActiveOperationSupport.getDefaultCallback();
        return this.registerActiveOperation(id, attachment, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, A> ActiveOperation<T, A> registerActiveOperation(Integer id, A attachment, ActiveOperation.CompletedCallback<T> callback) {
        this.lock.lock();
        try {
            Integer operationId;
            if (id == null) {
                operationId = this.operationIdManager.createBatchId();
            } else {
                if (!this.operationIdManager.lockBatchId(id)) {
                    throw ProtocolLogger.ROOT_LOGGER.operationIdAlreadyExists(id);
                }
                operationId = id;
            }
            ActiveOperationImpl request = new ActiveOperationImpl(operationId, attachment, ActiveOperationSupport.getCheckedCallback(callback));
            ActiveOperation existing = this.activeRequests.putIfAbsent(operationId, request);
            if (existing != null) {
                throw ProtocolLogger.ROOT_LOGGER.operationIdAlreadyExists(operationId);
            }
            ProtocolLogger.ROOT_LOGGER.tracef("Registered active operation %d", (Object)operationId);
            ++this.activeCount;
            ActiveOperationImpl activeOperationImpl = request;
            return activeOperationImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected <T, A> ActiveOperation<T, A> getActiveOperation(ManagementRequestHeader header) {
        return this.getActiveOperation(header.getBatchId());
    }

    protected <T, A> ActiveOperation<T, A> getActiveOperation(Integer id) {
        return (ActiveOperation)this.activeRequests.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, A> ActiveOperation<T, A> removeActiveOperation(Integer id) {
        this.lock.lock();
        try {
            ActiveOperation removed = (ActiveOperation)this.activeRequests.remove(id);
            if (removed != null) {
                ProtocolLogger.ROOT_LOGGER.tracef("Deregistered active operation %d", (Object)id);
                --this.activeCount;
                this.operationIdManager.freeBatchId(id);
                this.condition.signalAll();
            }
            ActiveOperation activeOperation = removed;
            return activeOperation;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void handleChannelClosed(Channel closed, IOException e) {
        for (ActiveOperationImpl activeOperation : this.activeRequests.values()) {
            if (activeOperation.channel != closed) continue;
            activeOperation.getResultHandler().cancel();
        }
    }

    protected List<Integer> cancelAllActiveOperations() {
        ArrayList<Integer> operations = new ArrayList<Integer>();
        for (ActiveOperationImpl activeOperation : this.activeRequests.values()) {
            activeOperation.asyncCancel(false);
            operations.add(activeOperation.getOperationId());
        }
        return operations;
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    protected void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = unit.toMillis(timeout) + System.currentTimeMillis();
        this.lock.lock();
        try {
            boolean allComplete;
            long remaining;
            assert (this.shutdown);
            while (this.activeCount != 0 && (remaining = deadline - System.currentTimeMillis()) > 0L) {
                this.condition.await(remaining, TimeUnit.MILLISECONDS);
            }
            boolean bl = allComplete = this.activeCount == 0;
            if (!allComplete) {
                ProtocolLogger.ROOT_LOGGER.debugf("ActiveOperation(s) %s have not completed within %d %s", (Object)this.activeRequests.keySet(), (Object)timeout, (Object)unit);
            }
            boolean bl2 = allComplete;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    static void updateChannelRef(ActiveOperation<?, ?> operation, Channel channel) {
        ActiveOperationImpl a;
        if (operation instanceof ActiveOperationImpl && (a = (ActiveOperationImpl)operation).channel == null) {
            a.channel = channel;
        }
    }

    protected class ActiveOperationImpl<T, A>
    extends AsyncFutureTask<T>
    implements ActiveOperation<T, A> {
        private final A attachment;
        private final Integer operationId;
        private List<Cancellable> cancellables;
        private volatile Channel channel;
        private final ActiveOperation.ResultHandler<T> completionHandler;

        private ActiveOperationImpl(final Integer operationId, A attachment, final ActiveOperation.CompletedCallback<T> callback) {
            super(directExecutor);
            this.completionHandler = new ActiveOperation.ResultHandler<T>(){

                @Override
                public boolean done(T result) {
                    try {
                        boolean bl = ActiveOperationImpl.this.setResult(result);
                        return bl;
                    }
                    finally {
                        ActiveOperationSupport.this.removeActiveOperation(ActiveOperationImpl.this.operationId);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean failed(Throwable t) {
                    try {
                        boolean failed = ActiveOperationImpl.this.setFailed(t);
                        if (failed) {
                            ProtocolLogger.ROOT_LOGGER.debugf(t, "active-op (%d) failed %s", (Object)ActiveOperationImpl.this.operationId, ActiveOperationImpl.this.attachment);
                        }
                        boolean bl = failed;
                        return bl;
                    }
                    finally {
                        ActiveOperationSupport.this.removeActiveOperation(ActiveOperationImpl.this.operationId);
                    }
                }

                @Override
                public void cancel() {
                    ProtocolLogger.CONNECTION_LOGGER.debugf("Operation (%d) cancelled", (Object)ActiveOperationImpl.this.operationId);
                    ActiveOperationImpl.this.cancel();
                }
            };
            this.operationId = operationId;
            this.attachment = attachment;
            this.addListener(new AsyncFuture.Listener<T, Object>(){

                @Override
                public void handleComplete(AsyncFuture<? extends T> asyncFuture, Object attachment) {
                    try {
                        callback.completed(asyncFuture.get());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void handleFailed(AsyncFuture<? extends T> asyncFuture, Throwable cause, Object attachment) {
                    if (cause instanceof Exception) {
                        callback.failed((Exception)cause);
                    } else {
                        callback.failed(new RuntimeException(cause));
                    }
                }

                @Override
                public void handleCancelled(AsyncFuture<? extends T> asyncFuture, Object attachment) {
                    ActiveOperationSupport.this.removeActiveOperation(operationId);
                    callback.cancelled();
                    ProtocolLogger.ROOT_LOGGER.debugf("cancelled operation (%d) attachment: (%s) this: %s.", (Object)ActiveOperationImpl.this.getOperationId(), ActiveOperationImpl.this.getAttachment(), (Object)ActiveOperationSupport.this);
                }
            }, null);
        }

        @Override
        public Integer getOperationId() {
            return this.operationId;
        }

        @Override
        public ActiveOperation.ResultHandler<T> getResultHandler() {
            return this.completionHandler;
        }

        @Override
        public A getAttachment() {
            return this.attachment;
        }

        @Override
        public AsyncFuture<T> getResult() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncCancel(boolean interruptionDesired) {
            List<Cancellable> cancellables;
            ActiveOperationImpl activeOperationImpl = this;
            synchronized (activeOperationImpl) {
                cancellables = this.cancellables;
                if (cancellables == CANCEL_REQUESTED) {
                    return;
                }
                this.cancellables = CANCEL_REQUESTED;
                if (cancellables == null) {
                    this.setCancelled();
                    return;
                }
            }
            for (Cancellable cancellable : cancellables) {
                cancellable.cancel();
            }
            this.setCancelled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCancellable(Cancellable cancellable) {
            ActiveOperationImpl activeOperationImpl = this;
            synchronized (activeOperationImpl) {
                switch (this.getStatus()) {
                    case CANCELLED: {
                        break;
                    }
                    case WAITING: {
                        List<Cancellable> cancellables = this.cancellables;
                        if (cancellables == CANCEL_REQUESTED) break;
                        (cancellables == null ? (this.cancellables = new ArrayList<Cancellable>()) : cancellables).add(cancellable);
                    }
                    default: {
                        return;
                    }
                }
            }
            cancellable.cancel();
        }

        public boolean cancel() {
            return super.cancel(true);
        }
    }
}

