/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.capability.registry;

import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.ProcessType;
import infinispan.org.jboss.as.controller.capability.registry.CapabilityResolutionContext;
import infinispan.org.jboss.as.controller.capability.registry.HostCapabilityScope;
import infinispan.org.jboss.as.controller.capability.registry.ProfileChildCapabilityScope;
import infinispan.org.jboss.as.controller.capability.registry.ProfilesCapabilityScope;
import infinispan.org.jboss.as.controller.capability.registry.ServerConfigCapabilityScope;
import infinispan.org.jboss.as.controller.capability.registry.ServerGroupsCapabilityScope;
import infinispan.org.jboss.as.controller.capability.registry.SocketBindingGroupChildScope;
import infinispan.org.jboss.as.controller.capability.registry.SocketBindingGroupsCapabilityScope;
import java.util.Collections;
import java.util.Set;

public interface CapabilityScope {
    public static final CapabilityScope GLOBAL = new CapabilityScope(){

        @Override
        public boolean canSatisfyRequirement(String requiredName, CapabilityScope dependentScope, CapabilityResolutionContext context) {
            return true;
        }

        @Override
        public boolean requiresConsistencyCheck() {
            return false;
        }

        @Override
        public String getName() {
            return "global";
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{global}";
        }
    };

    public boolean canSatisfyRequirement(String var1, CapabilityScope var2, CapabilityResolutionContext var3);

    public boolean requiresConsistencyCheck();

    public String getName();

    default public Set<CapabilityScope> getIncludingScopes(CapabilityResolutionContext context) {
        return Collections.emptySet();
    }

    public static class Factory {
        public static CapabilityScope create(ProcessType processType, PathAddress address) {
            PathElement pe;
            CapabilityScope context = GLOBAL;
            PathElement pathElement = pe = processType.isServer() || address.size() == 0 ? null : address.getElement(0);
            if (pe != null) {
                String type;
                switch (type = pe.getKey()) {
                    case "profile": {
                        context = address.size() == 1 ? ProfilesCapabilityScope.INSTANCE : new ProfileChildCapabilityScope(pe.getValue());
                        break;
                    }
                    case "socket-binding-group": {
                        context = address.size() == 1 ? SocketBindingGroupsCapabilityScope.INSTANCE : new SocketBindingGroupChildScope(pe.getValue());
                        break;
                    }
                    case "host": {
                        String hostType;
                        if (address.size() < 2) break;
                        PathElement hostElement = address.getElement(1);
                        switch (hostType = hostElement.getKey()) {
                            case "subsystem": 
                            case "socket-binding-group": {
                                context = HostCapabilityScope.INSTANCE;
                                break;
                            }
                            case "server-config": {
                                context = ServerConfigCapabilityScope.INSTANCE;
                            }
                        }
                        break;
                    }
                    case "server-group": {
                        context = ServerGroupsCapabilityScope.INSTANCE;
                    }
                }
            }
            return context;
        }
    }
}

