/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.persistence;

import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import infinispan.org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import infinispan.org.jboss.as.controller.persistence.ConfigurationPersister;
import infinispan.org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import infinispan.org.jboss.dmr.ModelNode;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import org.xnio.IoUtils;

public abstract class AbstractFilePersistenceResource
implements ConfigurationPersister.PersistenceResource {
    private volatile ExposedByteArrayOutputStream marshalled = new ExposedByteArrayOutputStream(8192);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractFilePersistenceResource(ModelNode model, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        try {
            try {
                BufferedOutputStream output = new BufferedOutputStream(this.marshalled);
                persister.marshallAsXml(model, output);
                output.close();
                this.marshalled.close();
            }
            finally {
                IoUtils.safeClose((Closeable)this.marshalled);
            }
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.failedToMarshalConfiguration(e);
        }
    }

    @Override
    public void commit() {
        if (this.marshalled == null) {
            throw ControllerLogger.ROOT_LOGGER.rollbackAlreadyInvoked();
        }
        this.doCommit(this.marshalled);
    }

    @Override
    public void rollback() {
        this.marshalled = null;
    }

    protected abstract void doCommit(ExposedByteArrayOutputStream var1);
}

