/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.services.path;

import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinition;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import infinispan.org.jboss.as.controller.SimpleResourceDefinition;
import infinispan.org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.operations.global.ReadAttributeGroupHandler;
import infinispan.org.jboss.as.controller.operations.global.ReadAttributeHandler;
import infinispan.org.jboss.as.controller.operations.global.ReadResourceHandler;
import infinispan.org.jboss.as.controller.operations.validation.StringLengthValidator;
import infinispan.org.jboss.as.controller.registry.ManagementResourceRegistration;
import infinispan.org.jboss.as.controller.services.path.PathAddHandler;
import infinispan.org.jboss.as.controller.services.path.PathManagerService;
import infinispan.org.jboss.as.controller.services.path.PathRemoveHandler;
import infinispan.org.jboss.as.controller.services.path.PathWriteAttributeHandler;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;

public abstract class PathResourceDefinition
extends SimpleResourceDefinition {
    private static final String SPECIFIED_PATH_RESOURCE_PREFIX = "specified_path";
    private static final String NAMED_PATH_RESOURCE_PREFIX = "named_path";
    public static final PathElement PATH_ADDRESS = PathElement.pathElement("path");
    static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("name", ModelType.STRING, false).setValidator(new StringLengthValidator(1, false))).setResourceOnly()).build();
    static final SimpleAttributeDefinition PATH_SPECIFIED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("path", ModelType.STRING, false).setAllowExpression(true)).setValidator(new StringLengthValidator(1, false))).addArbitraryDescriptor("filesystem-path", new ModelNode(true))).build();
    static final SimpleAttributeDefinition PATH_NAMED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("path", ModelType.STRING, true).setAllowExpression(true)).setValidator(new StringLengthValidator(1, true))).build();
    static final SimpleAttributeDefinition READ_ONLY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("read-only", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition PATH = SimpleAttributeDefinitionBuilder.create(PATH_SPECIFIED).build();
    public static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("relative-to", ModelType.STRING, true).setValidator(new StringLengthValidator(1, true))).build();
    protected final PathManagerService pathManager;
    private final boolean specified;
    private final boolean services;
    private final boolean resolvable;

    private PathResourceDefinition(PathManagerService pathManager, ResourceDescriptionResolver resolver, PathAddHandler addHandler, PathRemoveHandler removeHandler, boolean specified, boolean services, boolean resolvable) {
        super(PATH_ADDRESS, resolver, addHandler, removeHandler);
        this.pathManager = pathManager;
        this.specified = specified;
        this.services = services;
        this.resolvable = resolvable;
    }

    public static PathResourceDefinition createResolvableSpecified(PathManagerService pathManager) {
        return new SpecifiedPathResourceDefinition(pathManager, true);
    }

    public static PathResourceDefinition createSpecified(PathManagerService pathManager) {
        return new SpecifiedPathResourceDefinition(pathManager, false);
    }

    public static PathResourceDefinition createNamed(PathManagerService pathManager) {
        return new NamedPathResourceDefinition(pathManager, false);
    }

    public static PathResourceDefinition createSpecifiedNoServices(PathManagerService pathManager) {
        return new SpecifiedNoServicesPathResourceDefinition(pathManager, false);
    }

    @Override
    public void registerOperations(ManagementResourceRegistration interfaces) {
        super.registerOperations(interfaces);
        if (this.resolvable) {
            interfaces.registerOperationHandler(ReadResourceHandler.RESOLVE_DEFINITION, ReadResourceHandler.RESOLVE_INSTANCE, true);
            interfaces.registerOperationHandler(ReadAttributeHandler.RESOLVE_DEFINITION, ReadAttributeHandler.RESOLVE_INSTANCE, true);
            interfaces.registerOperationHandler(ReadAttributeGroupHandler.RESOLVE_DEFINITION, ReadAttributeGroupHandler.RESOLVE_INSTANCE, true);
        }
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(NAME, ReadResourceNameOperationStepHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute(RELATIVE_TO, null, new PathWriteAttributeHandler(this.pathManager, RELATIVE_TO, this.services));
        SimpleAttributeDefinition pathAttr = this.specified ? PATH_SPECIFIED : PATH_NAMED;
        resourceRegistration.registerReadWriteAttribute(pathAttr, null, new PathWriteAttributeHandler(this.pathManager, pathAttr, this.services));
        resourceRegistration.registerReadOnlyAttribute(READ_ONLY, null);
    }

    private static class SpecifiedNoServicesPathResourceDefinition
    extends PathResourceDefinition {
        SpecifiedNoServicesPathResourceDefinition(PathManagerService pathManager, boolean resolvable) {
            super(pathManager, ControllerResolver.getResolver(PathResourceDefinition.SPECIFIED_PATH_RESOURCE_PREFIX), PathAddHandler.createSpecifiedNoServicesInstance(pathManager), PathRemoveHandler.createSpecifiedNoServicesInstance(pathManager), true, false, resolvable);
        }
    }

    private static class NamedPathResourceDefinition
    extends PathResourceDefinition {
        NamedPathResourceDefinition(PathManagerService pathManager, boolean resolvable) {
            super(pathManager, ControllerResolver.getResolver(PathResourceDefinition.NAMED_PATH_RESOURCE_PREFIX), PathAddHandler.createNamedInstance(pathManager), PathRemoveHandler.createNamedInstance(pathManager), false, false, resolvable);
        }
    }

    private static class SpecifiedPathResourceDefinition
    extends PathResourceDefinition {
        SpecifiedPathResourceDefinition(PathManagerService pathManager, boolean resolvable) {
            super(pathManager, ControllerResolver.getResolver(PathResourceDefinition.SPECIFIED_PATH_RESOURCE_PREFIX), PathAddHandler.createSpecifiedInstance(pathManager), PathRemoveHandler.createSpecifiedInstance(pathManager), true, true, resolvable);
        }
    }
}

