/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.protocol;

import infinispan.org.jboss.as.protocol.ProtocolTimeoutHandler;
import java.util.concurrent.TimeUnit;
import org.xnio.IoFuture;

public class GeneralTimeoutHandler
implements ProtocolTimeoutHandler {
    private volatile boolean thinking = false;
    private volatile long thinkTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendAndExecute(Runnable runnable) {
        this.thinking = true;
        long startThinking = System.currentTimeMillis();
        try {
            runnable.run();
        }
        finally {
            this.thinkTime += System.currentTimeMillis() - startThinking;
            this.thinking = false;
        }
    }

    @Override
    public IoFuture.Status await(IoFuture<?> future, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        IoFuture.Status status = future.await(timeoutMillis, TimeUnit.MILLISECONDS);
        while (status == IoFuture.Status.WAITING) {
            if (this.thinking) {
                status = future.await(timeoutMillis, TimeUnit.MILLISECONDS);
                continue;
            }
            long timeToWait = timeoutMillis + this.thinkTime - (System.currentTimeMillis() - startTime);
            if (timeToWait > 0L) {
                status = future.await(timeToWait, TimeUnit.MILLISECONDS);
                continue;
            }
            return status;
        }
        return status;
    }
}

