/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.audit;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.audit.AuditLogItem;
import infinispan.org.jboss.as.controller.audit.AuditLogItemFormatter;
import infinispan.org.jboss.dmr.ModelNode;

public class JsonAuditLogItemFormatter
extends AuditLogItemFormatter {
    private static final ModelNode UNDEFINED = new ModelNode();
    public static final String TYPE = "type";
    public static final String READ_ONLY = "r/o";
    public static final String BOOTING = "booting";
    public static final String AS_VERSION = "version";
    public static final String USER_ID = "user";
    public static final String DOMAIN_UUID = "domainUUID";
    public static final String ACCESS_MECHANISM = "access";
    public static final String REMOTE_ADDRESS = "remote-address";
    public static final String OPERATIONS = "ops";
    public static final String SUCCESS = "success";
    public static final String METHOD_NAME = "method";
    public static final String METHOD_SIGNATURE = "sig";
    public static final String METHOD_PARAMETERS = "params";
    public static final String ERROR = "error";
    private volatile boolean compactJson;
    private volatile boolean escapeNewLine;
    private volatile boolean escapeControlCharacters;

    public JsonAuditLogItemFormatter(String name, boolean includeDate, String dateSeparator, String dateFormat, boolean compactJson, boolean escapeNewLine, boolean escapeControlCharacters) {
        super(name, includeDate, dateSeparator, dateFormat);
        this.compactJson = compactJson;
        this.escapeNewLine = escapeNewLine;
        this.escapeControlCharacters = escapeControlCharacters;
    }

    public boolean isCompactJson() {
        return this.compactJson;
    }

    public void setCompactJson(boolean compactJson) {
        this.compactJson = compactJson;
    }

    public void setEscapeNewLine(boolean escapeNewLine) {
        this.escapeNewLine = escapeNewLine;
    }

    public void setEscapeControlCharacters(boolean escapeControlCharacters) {
        this.escapeControlCharacters = escapeControlCharacters;
    }

    @Override
    public String formatAuditLogItem(AuditLogItem.ModelControllerAuditLogItem item) {
        String formattedString = this.getCachedString();
        if (formattedString != null) {
            return formattedString;
        }
        ModelNode formatted = new ModelNode();
        formatted.get(TYPE).set("core");
        this.addCommonFields(item, formatted);
        formatted.get(SUCCESS).set(item.getResultAction() == OperationContext.ResultAction.KEEP);
        formatted.get(OPERATIONS).set(item.getOperations());
        return this.cacheString(this.createRecordText(item, formatted));
    }

    @Override
    public String formatAuditLogItem(AuditLogItem.JmxAccessAuditLogItem item) {
        String formattedString = this.getCachedString();
        if (formattedString != null) {
            return formattedString;
        }
        ModelNode formatted = new ModelNode();
        formatted.get(TYPE).set("jmx");
        this.addCommonFields(item, formatted);
        formatted.get(METHOD_NAME).set(item.getMethodName());
        formatted.get(METHOD_SIGNATURE);
        for (String sig : item.getMethodSignature()) {
            formatted.get(METHOD_SIGNATURE).add(sig);
        }
        formatted.get(METHOD_PARAMETERS);
        for (Object param : item.getMethodParams()) {
            formatted.get(METHOD_PARAMETERS).add(param == null ? UNDEFINED : new ModelNode(param.toString()));
        }
        Throwable throwable = item.getError();
        if (throwable != null) {
            formatted.get(ERROR).set(throwable.getMessage());
        }
        return this.cacheString(this.createRecordText(item, formatted));
    }

    private String createRecordText(AuditLogItem item, ModelNode formatted) {
        String formattedString;
        StringBuilder sb = new StringBuilder();
        this.appendDate(sb, item);
        sb.append(formatted.toJSONString(this.compactJson));
        if (this.escapeNewLine && !this.escapeControlCharacters) {
            formattedString = sb.toString().replace("\n", "#012");
        } else if (this.escapeControlCharacters) {
            StringBuilder escaped = new StringBuilder();
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c >= '\u0000' && c < ' ') {
                    escaped.append('#');
                    if (c < '\b') {
                        escaped.append('0').append('0').append((int)c);
                        continue;
                    }
                    escaped.append('0').append(c >> 3).append(c & 7);
                    continue;
                }
                escaped.append(c);
            }
            formattedString = escaped.toString();
        } else {
            formattedString = sb.toString();
        }
        return formattedString;
    }

    private void addCommonFields(AuditLogItem item, ModelNode formatted) {
        formatted.get(READ_ONLY).set(item.isReadOnly());
        formatted.get(BOOTING).set(item.isBooting());
        formatted.get(AS_VERSION).set(item.getAsVersion());
        formatted.get(USER_ID);
        if (item.getUserId() != null) {
            formatted.get(USER_ID).set(item.getUserId());
        }
        formatted.get(DOMAIN_UUID);
        if (item.getDomainUUID() != null) {
            formatted.get(DOMAIN_UUID).set(item.getDomainUUID());
        }
        formatted.get(ACCESS_MECHANISM);
        if (item.getAccessMechanism() != null) {
            formatted.get(ACCESS_MECHANISM).set(item.getAccessMechanism().toString());
        }
        formatted.get(REMOTE_ADDRESS);
        if (item.getRemoteAddress() != null) {
            formatted.get(REMOTE_ADDRESS).set(item.getRemoteAddress().toString());
        }
    }

    public static void getJsonFormatter(String nameFromAddress) {
    }

    static {
        UNDEFINED.protect();
    }
}

